/*
 * Decompiled with CFR 0.152.
 */
package org.abs.bifrost;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import org.abs.bifrost.Environment;
import org.abs.bifrost.GroundControl;
import org.abs.bifrost.Renderer;
import org.abs.bifrost.TaskMaster;
import org.abs.bifrost.gui.BifrostSplash;
import org.abs.bifrost.gui.Mainmenu;
import org.abs.bifrost.gui.chat.ChatDisplay;
import org.abs.bifrost.gui.chat.ChatTextfield;
import org.abs.bifrost.gui.chat.ChatUsers;
import org.abs.bifrost.gui.chat.User;
import org.abs.bifrost.physics.Simulator;
import org.abs.bifrost.physics.Vector;
import org.abs.bifrost.tcpip.BifrostPayload;

public class MainScreen {
    public static final String version = "0.5.1a";
    GroundControl gc;
    Mainmenu mm;
    BifrostSplash bf = new BifrostSplash();

    public static void main(String[] args) {
        new MainScreen();
    }

    public MainScreen() {
        this.bf.showSplash();
        this.bf.setText("Creating GroundControl...");
        this.gc = new GroundControl();
        this.gc.setUser(new User(0, "DefaultUser", 5));
        this.gc.setTimeStep(0.001);
        this.gc.setAmbientgravity(true);
        this.gc.setGravity(false);
        this.gc.setFluidResistance(false);
        this.gc.setBorderBounce(true, true, true, true);
        this.bf.setText("Creating Environment...");
        Environment env = new Environment();
        env.setGravity(new Vector(0.0, -9.8));
        env.setppm(10.0);
        env.setEfield(new Vector(0.0, 0.0));
        this.gc.setEnv(env);
        this.bf.setText("Creating Main Frame...");
        JFrame container = new JFrame("Bifr\u00f6st Physics - v0.5.1a");
        Image icon = new ImageIcon(this.getClass().getResource("gui/imgs/icon.gif")).getImage();
        this.gc.setIcon(icon);
        container.setIconImage(icon);
        container.addWindowListener(new CWindowListener());
        int width = 800;
        int height = 600;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screen.width - width) / 2;
        int y = (screen.height - height) / 2;
        container.setBounds(x, y, width, height);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new GlobalListener());
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        JPanel panel = (JPanel)container.getContentPane();
        panel.setPreferredSize(new Dimension(width, height));
        panel.setLayout(new BorderLayout());
        this.bf.setText("Creating Renderer...");
        Renderer renderer = new Renderer(this.gc);
        Thread thread_renderer = new Thread(renderer);
        this.gc.setRenderer(renderer);
        this.bf.setText("Creating Simulator...");
        Simulator simulator = new Simulator(this.gc);
        Thread thread_simulator = new Thread(simulator);
        this.bf.setText("Creating Taskmaster...");
        TaskMaster taskmaster = new TaskMaster(this.gc);
        Thread thread_taskmaster = new Thread(taskmaster);
        thread_taskmaster.start();
        this.bf.setText("Creating Chat display...");
        Panel chatpanel = new Panel();
        chatpanel.setLayout(new BorderLayout());
        ChatDisplay cd = new ChatDisplay();
        this.gc.setChatdisplay(cd);
        chatpanel.add((Component)cd, "Center");
        ChatTextfield ct = new ChatTextfield(this.gc, new User(0, "User"));
        chatpanel.add((Component)ct, "South");
        ChatUsers cu = new ChatUsers(this.gc);
        cd.setCu(cu);
        cu.addUser(this.gc.getUser());
        chatpanel.add((Component)cu, "East");
        this.bf.setText("Creating Mainmenu and allocating quicksave...");
        this.mm = new Mainmenu(this.gc);
        panel.add((Component)this.mm, "North");
        panel.add((Component)renderer, "Center");
        panel.add((Component)chatpanel, "South");
        container.pack();
        try {
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.bf.done();
        container.setVisible(true);
        thread_renderer.start();
        thread_simulator.start();
    }

    private class CWindowListener
    implements WindowListener {
        private CWindowListener() {
        }

        @Override
        public void windowActivated(WindowEvent arg0) {
        }

        @Override
        public void windowClosed(WindowEvent arg0) {
        }

        @Override
        public void windowClosing(WindowEvent arg0) {
            if (MainScreen.this.gc.isClient()) {
                MainScreen.this.gc.getCmode().sendDisc();
            } else if (MainScreen.this.gc.isServer()) {
                MainScreen.this.gc.getSmode().shutDown();
            }
            while (true) {
                if (MainScreen.this.gc.isClient() || MainScreen.this.gc.isServer()) {
                    continue;
                }
                System.exit(0);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent arg0) {
        }

        @Override
        public void windowDeiconified(WindowEvent arg0) {
        }

        @Override
        public void windowIconified(WindowEvent arg0) {
        }

        @Override
        public void windowOpened(WindowEvent arg0) {
        }
    }

    private class GlobalListener
    implements KeyEventDispatcher {
        private GlobalListener() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (e.getID() == 401) {
                if (e.getKeyCode() == 116) {
                    MainScreen.this.mm.quickSave();
                } else if (e.getKeyCode() == 118) {
                    MainScreen.this.mm.quickLoad();
                } else if (e.getKeyCode() == 113) {
                    if (MainScreen.this.gc.isServer()) {
                        MainScreen.this.gc.getMm().pushPhys();
                    }
                } else if (e.isControlDown() && e.getKeyCode() == 32) {
                    if (MainScreen.this.gc.isServer()) {
                        if (MainScreen.this.gc.getRenderer().isPaused()) {
                            MainScreen.this.gc.getRenderer().play();
                            BifrostPayload pyld = new BifrostPayload();
                            pyld.setPyld(3);
                            MainScreen.this.gc.getSmode().getServer().send(pyld);
                        } else {
                            MainScreen.this.gc.getRenderer().pause();
                            BifrostPayload pyld = new BifrostPayload();
                            pyld.setPyld(4);
                            MainScreen.this.gc.getSmode().getServer().send(pyld);
                        }
                    } else if (!MainScreen.this.gc.isClient()) {
                        if (MainScreen.this.gc.getRenderer().isPaused()) {
                            MainScreen.this.gc.getRenderer().play();
                        } else {
                            MainScreen.this.gc.getRenderer().pause();
                        }
                    }
                }
            }
            return false;
        }
    }
}

