/*
 * Decompiled with CFR 0.152.
 */
package org.abs.bifrost;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferStrategy;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.event.MouseInputAdapter;
import org.abs.bifrost.GroundControl;
import org.abs.bifrost.entities.Ball;
import org.abs.bifrost.entities.Entity;
import org.abs.bifrost.entities.Generator;
import org.abs.bifrost.gui.EntityEditor;
import org.abs.bifrost.gui.EntityList;
import org.abs.bifrost.physics.Vector;

public class Renderer
extends Canvas
implements Runnable {
    private static final long serialVersionUID = 1L;
    private BufferStrategy strategy;
    private GroundControl groundcontrol;
    private boolean trace;
    private boolean paused;
    private int fcount = 0;
    private Vector boxinit;
    private Vector boxend;
    private boolean ctrl;
    private boolean alt;

    public Renderer(GroundControl groundcontrol) {
        this.groundcontrol = groundcontrol;
        this.boxinit = new Vector();
        this.boxend = new Vector();
        this.ctrl = false;
        this.alt = false;
        this.setIgnoreRepaint(true);
    }

    @Override
    public void run() {
        this.createBufferStrategy(2);
        this.strategy = this.getBufferStrategy();
        this.trace = true;
        this.addKeyListener(new KeyInputHandler());
        MouseInputHandler mih = new MouseInputHandler();
        this.addMouseListener(mih);
        this.addMouseMotionListener(mih);
        this.stop();
        while (true) {
            this.renderCycle();
        }
    }

    public void renderCycle() {
        Graphics2D g = (Graphics2D)this.strategy.getDrawGraphics();
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.groundcontrol.setEnvironmentHeight(this.getHeight());
        this.groundcontrol.setEnvironmentWidth(this.getWidth());
        ArrayList<Entity> ents = new ArrayList<Entity>(this.groundcontrol.getEntities());
        g.translate(0, this.getHeight());
        g.scale(1.0, -1.0);
        for (Entity entity : ents) {
            entity.draw(g);
            if (entity.isTrace() && this.trace && !this.isPaused()) {
                entity.addTrace();
            }
            if (entity.isFabulous() && this.trace && this.fcount == 0 && !this.isPaused()) {
                entity.beFabulous();
            }
            if (!entity.isDrawVelocity()) continue;
            Color c = new Color(255, 255, 255, 175);
            entity.getVelocity().draw(g, (int)entity.getPosition().getX(), (int)entity.getPosition().getY(), 2.0f, c);
        }
        Vector topLeft = new Vector();
        Vector bottomRight = new Vector();
        Vector boxend2 = new Vector(this.boxend);
        boxend2.setX(boxend2.getX() - this.boxinit.getX());
        boxend2.setY(boxend2.getY() - this.boxinit.getY());
        topLeft.setX(this.boxinit.getX() < this.boxend.getX() ? this.boxinit.getX() : this.boxend.getX());
        bottomRight.setX(this.boxinit.getX() > this.boxend.getX() ? this.boxinit.getX() : this.boxend.getX());
        topLeft.setY(this.boxinit.getY() > this.boxend.getY() ? this.boxinit.getY() : this.boxend.getY());
        bottomRight.setY(this.boxinit.getY() < this.boxend.getY() ? this.boxinit.getY() : this.boxend.getY());
        if (this.ctrl) {
            Rectangle rectBox = new Rectangle((int)topLeft.getX(), (int)(topLeft.getY() - Math.abs(boxend2.getY())), (int)Math.abs(boxend2.getX()), (int)Math.abs(boxend2.getY()));
            g.setColor(Color.red);
            g.draw(rectBox);
            Color temp = new Color(255, 0, 0, 100);
            g.setColor(temp);
            g.fill(rectBox);
        }
        if (this.alt) {
            boxend2.draw(g, (int)this.boxinit.getX(), (int)this.boxinit.getY(), 3.0f, Color.red);
            Graphics2D g2 = (Graphics2D)this.strategy.getDrawGraphics();
            g2.setColor(Color.red);
            g2.drawString(String.valueOf(Double.toString(boxend2.getR() / this.groundcontrol.getEnv().getppm())) + " m", (int)this.boxinit.getX(), (int)(this.groundcontrol.getEnvironmentHeight() - this.boxinit.getY()));
        }
        if (this.isPaused()) {
            Rectangle rect1 = new Rectangle(20, this.getHeight() - 95, 25, 75);
            Rectangle rect2 = new Rectangle(60, this.getHeight() - 95, 25, 75);
            g.setColor(Color.RED);
            g.fill(rect1);
            g.fill(rect2);
            g.setColor(Color.BLACK);
            g.draw(rect1);
            g.draw(rect2);
        }
        g.dispose();
        this.strategy.show();
        this.trace = !this.trace;
        this.fcount = this.fcount == 25 ? 0 : this.fcount + 1;
        try {
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void play() {
        this.groundcontrol.getChatdisplay().addConsoleLine("Simulation resumed.");
        this.groundcontrol.getMm().mi_Play.setText("Pause");
        this.setPaused(false);
    }

    public void stop() {
        this.groundcontrol.getChatdisplay().addConsoleLine("Simulation paused.");
        this.groundcontrol.getMm().mi_Play.setText("Play");
        this.setPaused(true);
    }

    public void pause() {
        if (!this.isPaused()) {
            this.stop();
        } else {
            this.play();
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    private class KeyInputHandler
    extends KeyAdapter {
        private KeyInputHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    private class MouseInputHandler
    extends MouseInputAdapter {
        Vector mousePressedLocation = null;
        Vector mouseReleasedLocation = null;

        @Override
        public void mousePressed(MouseEvent e) {
            this.mousePressedLocation = new Vector(e.getX(), Renderer.this.groundcontrol.getEnvironmentHeight() - (double)e.getY());
            Renderer.this.boxinit = new Vector(this.mousePressedLocation);
            Renderer.this.boxend = new Vector(this.mousePressedLocation);
            if (e.isControlDown()) {
                Renderer.this.ctrl = true;
            }
            if (e.isAltDown()) {
                Renderer.this.alt = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Renderer.this.boxinit = new Vector();
            Renderer.this.boxend = new Vector();
            Renderer.this.ctrl = false;
            Renderer.this.alt = false;
            if (e.isControlDown() && Renderer.this.isPaused()) {
                this.mouseReleasedLocation = new Vector(e.getX(), Renderer.this.groundcontrol.getEnvironmentHeight() - (double)e.getY());
                String ans = JOptionPane.showInputDialog("How many entities shall I generate?", (Object)"10");
                int amount = Integer.parseInt(ans);
                ans = JOptionPane.showInputDialog("What mass shall these entities have?", (Object)"15");
                Vector bottomLeft = new Vector();
                Vector topRight = new Vector();
                bottomLeft.setX(this.mousePressedLocation.getX() < this.mouseReleasedLocation.getX() ? this.mousePressedLocation.getX() : this.mouseReleasedLocation.getX());
                topRight.setX(this.mousePressedLocation.getX() > this.mouseReleasedLocation.getX() ? this.mousePressedLocation.getX() : this.mouseReleasedLocation.getX());
                bottomLeft.setY(this.mousePressedLocation.getY() < this.mouseReleasedLocation.getY() ? this.mousePressedLocation.getY() : this.mouseReleasedLocation.getY());
                topRight.setY(this.mousePressedLocation.getY() > this.mouseReleasedLocation.getY() ? this.mousePressedLocation.getY() : this.mouseReleasedLocation.getY());
                Generator.squareLattice(Renderer.this.groundcontrol, amount, bottomLeft, topRight, Double.parseDouble(ans));
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && Renderer.this.isPaused()) {
                if (e.isAltDown()) {
                    new EntityEditor(e, Renderer.this.groundcontrol, true);
                } else {
                    Vector v = new Vector(e.getX(), Renderer.this.groundcontrol.getEnvironmentHeight() - (double)e.getY());
                    int count = 0;
                    int index = -1;
                    int i = 0;
                    while (i < Renderer.this.groundcontrol.getEntities().size()) {
                        if (Generator.noCollision(v, (Ball)Renderer.this.groundcontrol.getEntities().get(i), Renderer.this.groundcontrol)) {
                            ++count;
                        } else {
                            index = i;
                        }
                        ++i;
                    }
                    if (count == Renderer.this.groundcontrol.getEntities().size()) {
                        new EntityEditor(e, Renderer.this.groundcontrol, true);
                    } else {
                        new EntityList(Renderer.this.groundcontrol, index);
                    }
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Vector v2 = new Vector(e.getX(), Renderer.this.groundcontrol.getEnvironmentHeight() - (double)e.getY());
            Renderer.this.boxend = new Vector(v2);
        }
    }
}

