/*
 * Decompiled with CFR 0.152.
 */
package org.abs.bifrost.entities;

import java.awt.geom.Ellipse2D;
import org.abs.bifrost.entities.Entity;
import org.abs.bifrost.physics.Physics;
import org.abs.bifrost.physics.Vector;

public class Ball
extends Entity {
    private double radius = this.getWidth();

    public Ball() {
        this.setDrag_coefficient(0.47);
        this.setShape(new Ellipse2D.Double(0.0, 0.0, 20.0, 20.0));
        this.updateShape();
    }

    @Override
    public void collide(Ball that) {
        if (!that.isCollidable() || !this.isCollidable()) {
            return;
        }
        for (Entity ent : this.getCollisions()) {
            if (that != ent && this != that) continue;
            return;
        }
        Vector direction = new Vector(that.getPosition().getX() - this.getPosition().getX(), that.getPosition().getY() - this.getPosition().getY());
        if (direction.getR() <= this.getRadius() + that.getRadius()) {
            Ball rightmost;
            double angle = direction.getAngle();
            this.getCollisions().add(that);
            that.getCollisions().add(this);
            this.getVelocity().rotate(-angle);
            that.getVelocity().rotate(-angle);
            this.getPosition().rotate(-angle);
            that.getPosition().rotate(-angle);
            Ball leftmost = this.getPosition().getX() < that.getPosition().getX() ? this : that;
            Ball ball = rightmost = this == leftmost ? that : this;
            if (leftmost.getVelocity().getX() < 0.0 && rightmost.getVelocity().getX() > 0.0) {
                this.getPosition().rotate(angle);
                that.getPosition().rotate(angle);
                that.getVelocity().rotate(angle);
                this.getVelocity().rotate(angle);
                return;
            }
            this.getPosition().rotate(angle);
            that.getPosition().rotate(angle);
            double[] newXvelocities = Physics.getPostInelasticVelocities(this.getVelocity().getX(), that.getVelocity().getX(), this.getMass(), that.getMass());
            if (this.isPinned()) {
                newXvelocities[0] = 0.0;
                newXvelocities[1] = -that.getVelocity().getX();
            }
            if (that.isPinned()) {
                newXvelocities[0] = -this.getVelocity().getX();
                newXvelocities[1] = 0.0;
            }
            this.getVelocity().setX(newXvelocities[0]);
            that.getVelocity().setX(newXvelocities[1]);
            this.getVelocity().rotate(angle);
            that.getVelocity().rotate(angle);
        }
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
        super.setWidth(2.0 * radius);
        super.setHeight(2.0 * radius);
    }

    @Override
    public void setWidth(double width) {
        super.setWidth(width);
        super.setHeight(width);
        this.radius = width / 2.0;
    }

    @Override
    public void setHeight(double height) {
        super.setWidth(height);
        super.setHeight(height);
        this.radius = height / 2.0;
    }
}

