/*
 * Decompiled with CFR 0.152.
 */
package org.abs.bifrost.entities;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import org.abs.bifrost.entities.Ball;
import org.abs.bifrost.physics.Vector;

public class Entity {
    private String name = "Entity";
    private Vector position;
    private Vector velocity;
    private double width = 5.0;
    private double height = 5.0;
    private double mass = 5.0;
    private double charge = 0.0;
    private double drag_coefficient = 0.0;
    private boolean trace = false;
    private int tracelimit = 250;
    private Color color;
    private RectangularShape shape;
    private boolean pinned = false;
    private boolean collidable = true;
    private ArrayList<Entity> collisions;
    private ArrayList<Entity> traces = new ArrayList();
    private boolean fabulous;
    private int fcount = 0;
    private boolean drawVelocity;

    public Entity() {
        this.collisions = new ArrayList();
        this.position = new Vector(0.0, 0.0);
        this.velocity = new Vector(0.0, 0.0);
        this.color = Color.GREEN;
        this.shape = new Ellipse2D.Double(0.0, 0.0, 20.0, 20.0);
    }

    public void addTrace() {
        if (this.tracelimit > 0 && this.traces.size() > this.tracelimit) {
            this.traces.remove(0);
        }
        Ball temp = new Ball();
        temp.setHeight(3.0);
        temp.setColor(this.getColor());
        temp.setPinned(true);
        temp.setCollidable(false);
        temp.getPosition().setX(this.getPosition().getX());
        temp.getPosition().setY(this.getPosition().getY());
        this.traces.add(temp);
    }

    public ArrayList<Entity> getCollisions() {
        return this.collisions;
    }

    public void setCollisions(ArrayList<Entity> collisions) {
        this.collisions = collisions;
    }

    public void collide(Entity that) {
        this.collide((Ball)that);
    }

    public void clearCollisions() {
        this.collisions = new ArrayList();
    }

    public void draw(Graphics2D g) {
        this.updateShape();
        g.setColor(this.color);
        g.fill(this.shape);
        if (this.isTrace()) {
            for (Entity ent : this.traces) {
                ent.draw(g);
            }
        }
    }

    public void updateShape() {
        this.shape.setFrame(new Rectangle((int)(this.position.getX() - this.shape.getWidth() / 2.0), (int)(this.position.getY() - this.shape.getHeight() / 2.0), (int)this.getWidth(), (int)this.getHeight()));
    }

    public Vector getPosition() {
        return this.position;
    }

    public void setPosition(Vector position) {
        this.position = position;
    }

    public Vector getVelocity() {
        return this.velocity;
    }

    public void setVelocity(Vector velocity) {
        this.velocity = velocity;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    public double getCharge() {
        return this.charge;
    }

    public void setCharge(double charge) {
        this.charge = charge;
    }

    public int getTracelimit() {
        return this.tracelimit;
    }

    public void setTracelimit(int tracelimit) {
        this.tracelimit = tracelimit;
    }

    public double getDrag_coefficient() {
        return this.drag_coefficient;
    }

    public void setDrag_coefficient(double dragCoefficient) {
        this.drag_coefficient = dragCoefficient;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public RectangularShape getShape() {
        return this.shape;
    }

    public void setShape(RectangularShape shape) {
        this.shape = shape;
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public void setPinned(boolean pinned) {
        this.pinned = pinned;
    }

    public boolean isCollidable() {
        return this.collidable;
    }

    public void setCollidable(boolean collidable) {
        this.collidable = collidable;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isDrawVelocity() {
        return this.drawVelocity;
    }

    public void setDrawVelocity(boolean drawVelocity) {
        this.drawVelocity = drawVelocity;
    }

    public void collide(Ball that) {
    }

    public void beFabulous() {
        Color[] fabulousColors = new Color[]{new Color(255, 0, 0), new Color(255, 127, 0), new Color(255, 255, 0), new Color(0, 255, 0), new Color(0, 0, 255), new Color(111, 0, 255), new Color(143, 0, 255)};
        this.setColor(fabulousColors[this.fcount % 7]);
        ++this.fcount;
    }

    public boolean isFabulous() {
        return this.fabulous;
    }

    public void setFabulous(boolean fabulous) {
        this.fabulous = fabulous;
        this.fcount = (int)(Math.random() * 100.0) % 7;
    }
}

