/*
 * Decompiled with CFR 0.152.
 */
package org.abs.bifrost.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.abs.bifrost.GroundControl;
import org.abs.bifrost.entities.Ball;
import org.abs.bifrost.entities.Entity;
import org.abs.bifrost.gui.EntityEditor;

public class EntityList
extends JFrame {
    private static final long serialVersionUID = 1L;
    private GroundControl gc;
    private JButton btn_delete;
    private JButton btn_edit;
    private JButton btn_cancel;
    private JList list;

    public EntityList(GroundControl gc, int defaultSelected) {
        super("Entity List");
        this.gc = gc;
        this.setIconImage(gc.getIcon());
        this.setLocation((int)(gc.getEnvironmentWidth() - 250.0) / 2, (int)(gc.getEnvironmentHeight() - 300.0) / 2);
        JPanel pnl_main = (JPanel)this.getContentPane();
        pnl_main.setPreferredSize(new Dimension(250, 300));
        pnl_main.setLayout(new BoxLayout(pnl_main, 1));
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (Entity e : gc.getEntities()) {
            model.addElement(e.getName());
        }
        JPanel pnl_button = new JPanel();
        pnl_button.setLayout(new BoxLayout(pnl_button, 0));
        this.btn_delete = new JButton("Delete");
        this.btn_delete.addActionListener(new Action_Delete(this));
        this.btn_delete.setMnemonic(68);
        this.btn_delete.setEnabled(false);
        this.btn_edit = new JButton("Edit");
        this.btn_edit.addActionListener(new Action_Edit(this));
        this.btn_edit.setMnemonic(69);
        this.btn_edit.setEnabled(false);
        this.btn_cancel = new JButton("Cancel");
        this.btn_cancel.addActionListener(new Action_Cancel(this));
        this.btn_cancel.setMnemonic(67);
        pnl_button.add(this.btn_edit);
        pnl_button.add(this.btn_delete);
        pnl_button.add(this.btn_cancel);
        this.list = new JList(model);
        if (defaultSelected != -1) {
            this.list.setSelectedIndex(defaultSelected);
            this.btn_edit.setEnabled(true);
            this.btn_delete.setEnabled(true);
        }
        this.list.addListSelectionListener(new ListSelectionAction());
        this.list.setSelectionMode(0);
        this.list.setLayoutOrientation(0);
        this.list.setVisibleRowCount(-1);
        JScrollPane listScroller = new JScrollPane(this.list);
        listScroller.setPreferredSize(new Dimension(250, 80));
        pnl_main.add(listScroller);
        pnl_main.add(pnl_button);
        this.pack();
        this.setVisible(true);
    }

    private class Action_Cancel
    implements ActionListener {
        private EntityList e;

        public Action_Cancel(EntityList e) {
            this.e = e;
        }

        @Override
        public void actionPerformed(ActionEvent q) {
            this.e.dispose();
        }
    }

    private class Action_Delete
    implements ActionListener {
        private EntityList e;

        public Action_Delete(EntityList e) {
            this.e = e;
        }

        @Override
        public void actionPerformed(ActionEvent q) {
            Object[] options = new Object[]{"Delete", "Cancel"};
            int n = JOptionPane.showOptionDialog(null, "Are you sure you want to delete this entity?\n", "Delete Confirmation", 1, 2, null, options, options[1]);
            if (n == 0) {
                EntityList.this.gc.getEntities().remove(EntityList.this.list.getSelectedIndex());
                new EntityList(EntityList.this.gc, -1);
                this.e.dispose();
            }
        }
    }

    private class Action_Edit
    implements ActionListener {
        private EntityList e;

        public Action_Edit(EntityList e) {
            this.e = e;
        }

        @Override
        public void actionPerformed(ActionEvent q) {
            new EntityEditor((Ball)EntityList.this.gc.getEntities().get(EntityList.this.list.getSelectedIndex()), EntityList.this.gc, false);
            EntityList.this.gc.getRenderer().renderCycle();
            this.e.dispose();
        }
    }

    class ListSelectionAction
    implements ListSelectionListener {
        ListSelectionAction() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (EntityList.this.list.getSelectedIndex() == -1) {
                    EntityList.this.btn_delete.setEnabled(false);
                    EntityList.this.btn_edit.setEnabled(false);
                } else {
                    EntityList.this.btn_delete.setEnabled(true);
                    EntityList.this.btn_edit.setEnabled(true);
                }
            }
        }
    }
}

