/*
 * Decompiled with CFR 0.152.
 */
package org.abs.bifrost.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.abs.bifrost.GroundControl;

public class EnvironmentEditor
extends JFrame {
    private static final long serialVersionUID = 1L;
    private GroundControl gc;
    private JTextField field_gravityX;
    private JTextField field_gravityY;
    private JTextField field_eX;
    private JTextField field_eY;
    private JTextField field_ppm;
    private JTextField field_fluiddensity;
    private JTextField field_timestep;
    private JCheckBox ambientgravity;
    private JCheckBox mutualgravity;
    private JCheckBox mutualelectric;
    private JCheckBox bounce_top;
    private JCheckBox bounce_right;
    private JCheckBox bounce_bottom;
    private JCheckBox bounce_left;
    private JCheckBox fluidresistance;
    private JButton button_accept;
    private JButton button_cancel;

    public EnvironmentEditor(GroundControl gc) {
        super("Environment Editor");
        this.gc = gc;
        this.setIconImage(gc.getIcon());
        this.setLocation((int)(gc.getEnvironmentWidth() - 325.0) / 2, (int)(gc.getEnvironmentHeight() - 300.0) / 2);
        JPanel pnl_main = (JPanel)this.getContentPane();
        pnl_main.setPreferredSize(new Dimension(325, 400));
        pnl_main.setLayout(new BoxLayout(pnl_main, 1));
        JPanel pnl_checkboxes = new JPanel();
        pnl_checkboxes.setLayout(new BoxLayout(pnl_checkboxes, 0));
        this.bounce_top = new JCheckBox();
        this.bounce_top.setSelected(gc.isTopBounce());
        pnl_checkboxes.add(this.bounce_top);
        pnl_checkboxes.add(new JLabel("Bounce Top"));
        pnl_main.add(pnl_checkboxes);
        pnl_checkboxes = new JPanel();
        pnl_checkboxes.setLayout(new BoxLayout(pnl_checkboxes, 0));
        this.bounce_right = new JCheckBox();
        this.bounce_right.setSelected(gc.isRightBounce());
        pnl_checkboxes.add(this.bounce_right);
        pnl_checkboxes.add(new JLabel("Bounce Right"));
        pnl_main.add(pnl_checkboxes);
        pnl_checkboxes = new JPanel();
        pnl_checkboxes.setLayout(new BoxLayout(pnl_checkboxes, 0));
        this.bounce_bottom = new JCheckBox();
        this.bounce_bottom.setSelected(gc.isBottomBounce());
        pnl_checkboxes.add(this.bounce_bottom);
        pnl_checkboxes.add(new JLabel("Bottom Bounce"));
        pnl_main.add(pnl_checkboxes);
        pnl_checkboxes = new JPanel();
        pnl_checkboxes.setLayout(new BoxLayout(pnl_checkboxes, 0));
        this.bounce_left = new JCheckBox();
        this.bounce_left.setSelected(gc.isRightBounce());
        pnl_checkboxes.add(this.bounce_left);
        pnl_checkboxes.add(new JLabel("Bottom Left"));
        pnl_main.add(pnl_checkboxes);
        pnl_checkboxes = new JPanel();
        pnl_checkboxes.setLayout(new BoxLayout(pnl_checkboxes, 0));
        this.ambientgravity = new JCheckBox();
        this.ambientgravity.setSelected(gc.isAmbientgravity());
        pnl_checkboxes.add(this.ambientgravity);
        pnl_checkboxes.add(new JLabel("Gravitational Field"));
        pnl_main.add(pnl_checkboxes);
        pnl_checkboxes = new JPanel();
        pnl_checkboxes.setLayout(new BoxLayout(pnl_checkboxes, 0));
        this.fluidresistance = new JCheckBox();
        this.fluidresistance.setSelected(gc.isFluidResistance());
        pnl_checkboxes.add(this.fluidresistance);
        pnl_checkboxes.add(new JLabel("Fluidic Resistance"));
        pnl_main.add(pnl_checkboxes);
        pnl_checkboxes = new JPanel();
        pnl_checkboxes.setLayout(new BoxLayout(pnl_checkboxes, 0));
        this.mutualgravity = new JCheckBox();
        this.mutualgravity.setSelected(gc.isGravity());
        pnl_checkboxes.add(this.mutualgravity);
        pnl_checkboxes.add(new JLabel("Mutual Gravitation"));
        pnl_main.add(pnl_checkboxes);
        pnl_checkboxes = new JPanel();
        pnl_checkboxes.setLayout(new BoxLayout(pnl_checkboxes, 0));
        this.mutualelectric = new JCheckBox();
        this.mutualelectric.setSelected(gc.isMutualelectric());
        pnl_checkboxes.add(this.mutualelectric);
        pnl_checkboxes.add(new JLabel("Mutual Electric"));
        pnl_main.add(pnl_checkboxes);
        JPanel pnl_ts = new JPanel();
        pnl_ts.setLayout(new BoxLayout(pnl_ts, 0));
        pnl_ts.add(new JLabel("Time Step: "));
        this.field_timestep = new JTextField();
        this.field_timestep.setText(Double.toString(gc.getTimeStep()));
        pnl_ts.add(this.field_timestep);
        pnl_main.add(pnl_ts);
        JPanel pnl_fd = new JPanel();
        pnl_fd.setLayout(new BoxLayout(pnl_fd, 0));
        pnl_fd.add(new JLabel("Fluid Density: "));
        this.field_fluiddensity = new JTextField();
        this.field_fluiddensity.setText(Double.toString(gc.getEnv().getFluidDensity()));
        pnl_fd.add(this.field_fluiddensity);
        pnl_fd.add(new JLabel("kg/m^3"));
        pnl_main.add(pnl_fd);
        JPanel pnl_ppm = new JPanel();
        pnl_ppm.setLayout(new BoxLayout(pnl_ppm, 0));
        pnl_ppm.add(new JLabel("PPM: "));
        this.field_ppm = new JTextField();
        this.field_ppm.setText(Double.toString(gc.getEnv().getppm()));
        pnl_ppm.add(this.field_ppm);
        pnl_ppm.add(new JLabel("pixel/meter"));
        pnl_main.add(pnl_ppm);
        JPanel pnl_gravity_x = new JPanel();
        pnl_gravity_x.setLayout(new BoxLayout(pnl_gravity_x, 0));
        pnl_gravity_x.add(new JLabel("Gravity X: "));
        this.field_gravityX = new JTextField();
        this.field_gravityX.setText(Double.toString(gc.getEnv().getGravity().getX()));
        pnl_gravity_x.add(this.field_gravityX);
        pnl_gravity_x.add(new JLabel("m/s^2"));
        pnl_main.add(pnl_gravity_x);
        JPanel pnl_gravity_y = new JPanel();
        pnl_gravity_y.setLayout(new BoxLayout(pnl_gravity_y, 0));
        pnl_gravity_y.add(new JLabel("Gravity Y: "));
        this.field_gravityY = new JTextField();
        this.field_gravityY.setText(Double.toString(gc.getEnv().getGravity().getY()));
        pnl_gravity_y.add(this.field_gravityY);
        pnl_gravity_y.add(new JLabel("m/s^2"));
        pnl_main.add(pnl_gravity_y);
        JPanel pnl_e_x = new JPanel();
        pnl_e_x.setLayout(new BoxLayout(pnl_e_x, 0));
        pnl_e_x.add(new JLabel("E Field X: "));
        this.field_eX = new JTextField();
        this.field_eX.setText(Double.toString(gc.getEnv().getEfield().getX()));
        pnl_e_x.add(this.field_eX);
        pnl_e_x.add(new JLabel("V/m"));
        pnl_main.add(pnl_e_x);
        JPanel pnl_e_y = new JPanel();
        pnl_e_y.setLayout(new BoxLayout(pnl_e_y, 0));
        pnl_e_y.add(new JLabel("E Field Y: "));
        this.field_eY = new JTextField();
        this.field_eY.setText(Double.toString(gc.getEnv().getEfield().getY()));
        pnl_e_y.add(this.field_eY);
        pnl_e_y.add(new JLabel("V/m"));
        pnl_main.add(pnl_e_y);
        JPanel pnl_buttons = new JPanel();
        pnl_buttons.setLayout(new BoxLayout(pnl_buttons, 0));
        this.button_accept = new JButton("Accept");
        this.button_cancel = new JButton("Cancel");
        this.button_accept.addActionListener(new Action_Accept(this));
        this.button_cancel.addActionListener(new Action_Cancel(this));
        this.button_accept.setMnemonic(65);
        this.button_cancel.setMnemonic(67);
        pnl_buttons.add(this.button_accept);
        pnl_buttons.add(this.button_cancel);
        pnl_main.add(pnl_buttons);
        this.pack();
        this.setVisible(true);
    }

    private class Action_Accept
    implements ActionListener {
        EnvironmentEditor e;

        public Action_Accept(EnvironmentEditor e) {
            this.e = e;
        }

        @Override
        public void actionPerformed(ActionEvent q) {
            EnvironmentEditor.this.gc.setBorderBounce(EnvironmentEditor.this.bounce_top.isSelected(), EnvironmentEditor.this.bounce_right.isSelected(), EnvironmentEditor.this.bounce_bottom.isSelected(), EnvironmentEditor.this.bounce_left.isSelected());
            EnvironmentEditor.this.gc.setFluidResistance(EnvironmentEditor.this.fluidresistance.isSelected());
            EnvironmentEditor.this.gc.setMutualelectric(EnvironmentEditor.this.mutualelectric.isSelected());
            EnvironmentEditor.this.gc.setGravity(EnvironmentEditor.this.mutualgravity.isSelected());
            EnvironmentEditor.this.gc.setAmbientgravity(EnvironmentEditor.this.ambientgravity.isSelected());
            EnvironmentEditor.this.gc.getEnv().getGravity().setX(Double.parseDouble(EnvironmentEditor.this.field_gravityX.getText()));
            EnvironmentEditor.this.gc.getEnv().getGravity().setY(Double.parseDouble(EnvironmentEditor.this.field_gravityY.getText()));
            EnvironmentEditor.this.gc.getEnv().getEfield().setX(Double.parseDouble(EnvironmentEditor.this.field_eX.getText()));
            EnvironmentEditor.this.gc.getEnv().getEfield().setY(Double.parseDouble(EnvironmentEditor.this.field_eY.getText()));
            EnvironmentEditor.this.gc.getEnv().setppm(Double.parseDouble(EnvironmentEditor.this.field_ppm.getText()));
            EnvironmentEditor.this.gc.getEnv().setFluidDensity(Double.parseDouble(EnvironmentEditor.this.field_fluiddensity.getText()));
            EnvironmentEditor.this.gc.setTimeStep(Double.parseDouble(EnvironmentEditor.this.field_timestep.getText()));
            this.e.dispose();
        }
    }

    private class Action_Cancel
    implements ActionListener {
        EnvironmentEditor e;

        public Action_Cancel(EnvironmentEditor e) {
            this.e = e;
        }

        @Override
        public void actionPerformed(ActionEvent q) {
            this.e.dispose();
        }
    }
}

