/*
 * Decompiled with CFR 0.152.
 */
package org.abs.bifrost.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Scanner;
import javax.swing.Box;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.abs.bifrost.GroundControl;
import org.abs.bifrost.entities.Entity;
import org.abs.bifrost.entities.Generator;
import org.abs.bifrost.fileio.BifrostFileFilter;
import org.abs.bifrost.fileio.FileHandler;
import org.abs.bifrost.gui.AboutWindow;
import org.abs.bifrost.gui.EntityEditor;
import org.abs.bifrost.gui.EntityList;
import org.abs.bifrost.gui.EnvironmentEditor;
import org.abs.bifrost.gui.chat.User;
import org.abs.bifrost.physics.Vector;
import org.abs.bifrost.tcpip.BifrostPayload;
import org.abs.bifrost.tcpip.ClientMode;
import org.abs.bifrost.tcpip.ServerMode;

public class Mainmenu
extends JMenuBar {
    private static final long serialVersionUID = 1L;
    private GroundControl gc;
    private JMenu menu_File;
    private JMenu menu_Entities;
    private JMenu menu_Environment;
    private JMenu menu_Networking;
    private JMenu menu_Help;
    private JMenuItem mi_Host;
    private JMenuItem mi_Connect;
    private JMenuItem mi_Push;
    private JMenuItem mi_Disconnect;
    public JMenuItem mi_Play;
    private File file_qs;
    private File file_ns;

    public Mainmenu(GroundControl gc) {
        this.gc = gc;
        gc.setMm(this);
        try {
            this.file_qs = File.createTempFile("bifrost" + System.currentTimeMillis(), "bpf");
            this.file_qs.deleteOnExit();
        }
        catch (IOException e) {
            e.printStackTrace();
            gc.getChatdisplay().addConsoleLine("Could not create quicksave file!");
        }
        try {
            this.file_ns = File.createTempFile("bifrostNetwork" + System.currentTimeMillis(), "bpf");
            this.file_ns.deleteOnExit();
        }
        catch (IOException e) {
            e.printStackTrace();
            gc.getChatdisplay().addConsoleLine("Could not create network save file!");
        }
        this.buildFileMenu();
        this.add(this.menu_File);
        this.buildEntitiesMenu();
        this.add(this.menu_Entities);
        this.buildEnvironmentMenu();
        this.add(this.menu_Environment);
        this.buildNetworkingMenu();
        this.add(this.menu_Networking);
        this.buildHelpMenu();
        this.add(this.menu_Help);
        this.add(Box.createGlue());
        this.buildPlaymenu();
        this.add(this.mi_Play);
    }

    public void pushPhys() {
        this.gc.getRenderer().setPaused(true);
        if (this.gc.isServer()) {
            FileHandler fh = new FileHandler(this.gc);
            fh.save(this.file_ns);
            Scanner sc = null;
            try {
                sc = new Scanner(this.file_ns);
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            ArrayList<String> as = new ArrayList<String>();
            while (sc.hasNextLine()) {
                as.add(sc.nextLine());
            }
            sc.close();
            BifrostPayload bp = new BifrostPayload();
            bp.setPyld(1);
            bp.packFile(as);
            this.gc.getSmode().getServer().send(bp);
        } else {
            this.gc.getChatdisplay().addConsoleLine("Not connected to server.");
        }
    }

    public void notifyRunning() {
        this.menu_File.setEnabled(false);
        this.menu_Entities.setEnabled(false);
        this.menu_Environment.setEnabled(false);
    }

    public void notifyPaused() {
        this.menu_File.setEnabled(true);
        this.menu_Entities.setEnabled(true);
        this.menu_Environment.setEnabled(true);
    }

    public void buildPlaymenu() {
        this.mi_Play = new JMenuItem("Play");
        this.mi_Play.setMnemonic(80);
        this.mi_Play.addActionListener(new Action_Play(this));
    }

    private void buildEnvironmentMenu() {
        this.menu_Environment = new JMenu("Environment");
        this.menu_Environment.setMnemonic(86);
        JMenuItem mi_EnvironmentEdit = new JMenuItem("Edit", 69);
        mi_EnvironmentEdit.addActionListener(new Action_Environment_Edit(this));
        this.menu_Environment.add(mi_EnvironmentEdit);
    }

    private void buildHelpMenu() {
        this.menu_Help = new JMenu("Help");
        this.menu_Help.setMnemonic(72);
        JMenuItem mi_About = new JMenuItem("About", 65);
        mi_About.addActionListener(new Action_Help_About(this));
        this.menu_Help.add(mi_About);
    }

    private void buildEntitiesMenu() {
        this.menu_Entities = new JMenu("Entities");
        this.menu_Entities.setMnemonic(69);
        JMenuItem mi_EntityAdd = new JMenuItem("Add", 65);
        mi_EntityAdd.addActionListener(new Action_Entity_Add(this));
        this.menu_Entities.add(mi_EntityAdd);
        JMenuItem mi_EntityEdit = new JMenuItem("Edit", 69);
        mi_EntityEdit.addActionListener(new Action_Entity_Edit(this));
        this.menu_Entities.add(mi_EntityEdit);
        this.menu_Entities.addSeparator();
        JMenu menu_Entity_Generator = new JMenu("Generator");
        menu_Entity_Generator.setMnemonic(71);
        JMenuItem mi_Generator_Random = new JMenuItem("Random");
        mi_Generator_Random.setMnemonic(82);
        mi_Generator_Random.addActionListener(new Action_Generator_Random(this));
        menu_Entity_Generator.add(mi_Generator_Random);
        JMenuItem mi_Generator_Random_Scaled = new JMenuItem("Random (Scaled)");
        mi_Generator_Random_Scaled.setMnemonic(83);
        mi_Generator_Random_Scaled.addActionListener(new Action_Generator_Random_Scaled(this));
        menu_Entity_Generator.add(mi_Generator_Random_Scaled);
        menu_Entity_Generator.addSeparator();
        JMenuItem mi_Generator_Column = new JMenuItem("Column");
        mi_Generator_Column.setMnemonic(67);
        mi_Generator_Column.addActionListener(new Action_Generator_Column(this));
        menu_Entity_Generator.add(mi_Generator_Column);
        JMenuItem mi_Generator_Row = new JMenuItem("Row");
        mi_Generator_Row.setMnemonic(87);
        mi_Generator_Row.addActionListener(new Action_Generator_Row(this));
        menu_Entity_Generator.add(mi_Generator_Row);
        menu_Entity_Generator.addSeparator();
        JMenuItem mi_Generator_LatticeSquare = new JMenuItem("Lattice (Square)");
        mi_Generator_LatticeSquare.setMnemonic(76);
        mi_Generator_LatticeSquare.addActionListener(new Action_Generator_LatticeSquare(this));
        menu_Entity_Generator.add(mi_Generator_LatticeSquare);
        this.menu_Entities.add(menu_Entity_Generator);
        JMenu menu_Entity_ToggleAll = new JMenu("Toggle All");
        menu_Entity_ToggleAll.setMnemonic(84);
        JMenuItem mi_Entity_Traceall = new JMenuItem("Trace");
        mi_Entity_Traceall.setMnemonic(84);
        mi_Entity_Traceall.addActionListener(new Action_Entity_TraceAll(this));
        menu_Entity_ToggleAll.add(mi_Entity_Traceall);
        JMenuItem mi_Entity_Vectorall = new JMenuItem("Draw Velocity Vectors");
        mi_Entity_Vectorall.setMnemonic(86);
        mi_Entity_Vectorall.addActionListener(new Action_Entity_VectorAll(this));
        menu_Entity_ToggleAll.add(mi_Entity_Vectorall);
        JMenuItem mi_Entity_PM = new JMenuItem("Party Mode");
        mi_Entity_PM.setMnemonic(80);
        mi_Entity_PM.addActionListener(new Action_Entity_PM(this));
        menu_Entity_ToggleAll.add(mi_Entity_PM);
        menu_Entity_ToggleAll.add(mi_Entity_PM);
        this.menu_Entities.add(menu_Entity_ToggleAll);
    }

    private void buildFileMenu() {
        this.menu_File = new JMenu("File");
        this.menu_File.setMnemonic(70);
        JMenuItem mi_New = new JMenuItem("New", 78);
        mi_New.addActionListener(new Action_New(this));
        this.menu_File.add(mi_New);
        JMenuItem mi_Save = new JMenuItem("Save", 83);
        mi_Save.addActionListener(new Action_Save(this));
        this.menu_File.add(mi_Save);
        JMenuItem mi_Open = new JMenuItem("Open", 79);
        mi_Open.addActionListener(new Action_Open(this));
        this.menu_File.add(mi_Open);
        this.menu_File.addSeparator();
        JMenuItem mi_Exit = new JMenuItem("Exit", 69);
        mi_Exit.addActionListener(new Action_Exit(this));
        this.menu_File.add(mi_Exit);
    }

    public void clientDC() {
        this.menu_File.setEnabled(true);
        this.menu_Entities.setEnabled(true);
        this.menu_Environment.setEnabled(true);
        this.mi_Play.setEnabled(true);
        this.mi_Host.setEnabled(true);
        this.mi_Connect.setEnabled(true);
        this.mi_Disconnect.setEnabled(false);
    }

    public void buildNetworkingMenu() {
        this.menu_Networking = new JMenu("Networking");
        this.menu_Networking.setMnemonic(78);
        this.mi_Connect = new JMenuItem("Connect", 67);
        this.mi_Connect.addActionListener(new Action_Network_Connect(this));
        this.menu_Networking.add(this.mi_Connect);
        this.mi_Host = new JMenuItem("Host", 72);
        this.mi_Host.addActionListener(new Action_Network_Host(this));
        this.menu_Networking.add(this.mi_Host);
        this.menu_Networking.addSeparator();
        this.mi_Push = new JMenuItem("Push Physics Data", 80);
        this.mi_Push.addActionListener(new Action_Network_PushPhysics(this));
        this.mi_Push.setEnabled(false);
        this.menu_Networking.add(this.mi_Push);
        this.menu_Networking.addSeparator();
        this.mi_Disconnect = new JMenuItem("Disconnect", 68);
        this.mi_Disconnect.addActionListener(new Action_Network_Disconnect(this));
        this.mi_Disconnect.setEnabled(false);
        this.menu_Networking.add(this.mi_Disconnect);
    }

    public void quickSave() {
        if (this.gc.getRenderer().isPaused()) {
            FileHandler fh = new FileHandler(this.gc);
            fh.save(this.file_qs);
        }
    }

    public void quickLoad() {
        if (this.gc.getRenderer().isPaused()) {
            FileHandler fh = new FileHandler(this.gc);
            fh.open(this.file_qs);
        }
    }

    public JMenuItem getMi_PlayPause() {
        return this.mi_Play;
    }

    public GroundControl getGc() {
        return this.gc;
    }

    private class Action_Entity_Add
    implements ActionListener {
        public Action_Entity_Add(Mainmenu m) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new EntityEditor(Mainmenu.this.gc, true);
        }
    }

    private class Action_Entity_Edit
    implements ActionListener {
        public Action_Entity_Edit(Mainmenu m) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new EntityList(Mainmenu.this.gc, -1);
        }
    }

    private class Action_Entity_PM
    implements ActionListener {
        public Action_Entity_PM(Mainmenu m) {
        }

        @Override
        public void actionPerformed(ActionEvent q) {
            for (Entity e : Mainmenu.this.gc.getEntities()) {
                e.setFabulous(!e.isFabulous());
            }
            Mainmenu.this.gc.getChatdisplay().addConsoleLine("Toggled fabulous settings for all entities");
        }
    }

    private class Action_Entity_TraceAll
    implements ActionListener {
        public Action_Entity_TraceAll(Mainmenu m) {
        }

        @Override
        public void actionPerformed(ActionEvent q) {
            String ans = JOptionPane.showInputDialog("What trace count limit?", (Object)"250");
            int amount = Integer.parseInt(ans);
            for (Entity e : Mainmenu.this.gc.getEntities()) {
                e.setTrace(!e.isTrace());
                e.setTracelimit(amount);
            }
            Mainmenu.this.gc.getChatdisplay().addConsoleLine("Toggled trace settings for all entities");
        }
    }

    private class Action_Entity_VectorAll
    implements ActionListener {
        public Action_Entity_VectorAll(Mainmenu m) {
        }

        @Override
        public void actionPerformed(ActionEvent q) {
            for (Entity e : Mainmenu.this.gc.getEntities()) {
                e.setDrawVelocity(!e.isDrawVelocity());
            }
            Mainmenu.this.gc.getChatdisplay().addConsoleLine("Toggled velocity vector drawing settings for all entities");
        }
    }

    private class Action_Environment_Edit
    implements ActionListener {
        public Action_Environment_Edit(Mainmenu m) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new EnvironmentEditor(Mainmenu.this.gc);
        }
    }

    private class Action_Exit
    implements ActionListener {
        public Action_Exit(Mainmenu m) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] options = new Object[]{"Exit", "Cancel"};
            int n = JOptionPane.showOptionDialog(null, "Are you sure you want to exit?\n(Changes will not be saved)", "Exit Confirmation", 1, 2, null, options, options[1]);
            if (n == 0) {
                if (Mainmenu.this.gc.isClient()) {
                    Mainmenu.this.gc.getCmode().sendDisc();
                } else if (Mainmenu.this.gc.isServer()) {
                    Mainmenu.this.gc.getSmode().shutDown();
                }
                while (true) {
                    if (Mainmenu.this.gc.isClient() || Mainmenu.this.gc.isServer()) {
                        continue;
                    }
                    System.exit(0);
                }
            }
        }
    }

    private class Action_Generator_Column
    implements ActionListener {
        public Action_Generator_Column(Mainmenu m) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Mainmenu.this.mi_Play.setEnabled(false);
            String ans = JOptionPane.showInputDialog("How many entities shall I generate?", (Object)"10");
            int amount = Integer.parseInt(ans);
            ans = JOptionPane.showInputDialog("Please list X Axis Position,Mass", (Object)"100,25");
            String[] args = ans.split(",");
            Generator.column(Mainmenu.this.gc, amount, Double.parseDouble(args[0]), Double.parseDouble(args[1]));
            Mainmenu.this.mi_Play.setEnabled(true);
        }
    }

    private class Action_Generator_LatticeSquare
    implements ActionListener {
        public Action_Generator_LatticeSquare(Mainmenu m) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Mainmenu.this.mi_Play.setEnabled(false);
            String ans = JOptionPane.showInputDialog("How many entities shall I generate?", (Object)"10");
            int amount = Integer.parseInt(ans);
            ans = JOptionPane.showInputDialog("Please list Bottom X, Bottom Y, Top X, Top Y, Mass", (Object)"0,0,100,100,15");
            String[] args = ans.split(",");
            Generator.squareLattice(Mainmenu.this.gc, amount, new Vector(Double.parseDouble(args[0]), Double.parseDouble(args[1])), new Vector(Double.parseDouble(args[2]), Double.parseDouble(args[3])), Double.parseDouble(args[4]));
            Mainmenu.this.mi_Play.setEnabled(true);
        }
    }

    private class Action_Generator_Random
    implements ActionListener {
        public Action_Generator_Random(Mainmenu m) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Mainmenu.this.mi_Play.setEnabled(false);
            String ans = JOptionPane.showInputDialog("How many entities shall I generate?", (Object)"10");
            int amount = Integer.parseInt(ans);
            ans = JOptionPane.showInputDialog("Please list MinMass,MaxMass,MaxSize,MaxVelocity", (Object)"4,5,25,25");
            String[] args = ans.split(",");
            Generator.random(Mainmenu.this.gc, amount, Double.parseDouble(args[0]), Double.parseDouble(args[1]), Double.parseDouble(args[2]), Double.parseDouble(args[3]));
            Mainmenu.this.mi_Play.setEnabled(true);
        }
    }

    private class Action_Generator_Random_Scaled
    implements ActionListener {
        public Action_Generator_Random_Scaled(Mainmenu m) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Mainmenu.this.mi_Play.setEnabled(false);
            String ans = JOptionPane.showInputDialog("How many entities shall I generate?", (Object)"10");
            int amount = Integer.parseInt(ans);
            ans = JOptionPane.showInputDialog("Please list MinMass,MaxMass,MaxVelocity", (Object)"4,5,25");
            String[] args = ans.split(",");
            Generator.random_scaled(Mainmenu.this.gc, amount, Double.parseDouble(args[0]), Double.parseDouble(args[1]), Double.parseDouble(args[2]));
            Mainmenu.this.mi_Play.setEnabled(true);
        }
    }

    private class Action_Generator_Row
    implements ActionListener {
        public Action_Generator_Row(Mainmenu m) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Mainmenu.this.mi_Play.setEnabled(false);
            String ans = JOptionPane.showInputDialog("How many entities shall I generate?", (Object)"10");
            int amount = Integer.parseInt(ans);
            ans = JOptionPane.showInputDialog("Please list Y Axis Position,Mass", (Object)"100,25");
            String[] args = ans.split(",");
            Generator.row(Mainmenu.this.gc, amount, Double.parseDouble(args[0]), Double.parseDouble(args[1]));
            Mainmenu.this.mi_Play.setEnabled(true);
        }
    }

    private class Action_Help_About
    implements ActionListener {
        public Action_Help_About(Mainmenu m) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                new AboutWindow();
            }
            catch (URISyntaxException e1) {
                e1.printStackTrace();
            }
        }
    }

    private class Action_Network_Connect
    implements ActionListener {
        public Action_Network_Connect(Mainmenu m) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Mainmenu.this.gc.getRenderer().setPaused(true);
            if (!Mainmenu.this.gc.isClient() && !Mainmenu.this.gc.isServer()) {
                String ans = JOptionPane.showInputDialog("What Username would you prefer?", (Object)"DefaultUser");
                Mainmenu.this.gc.getUser().setUsername(ans);
                ans = JOptionPane.showInputDialog("Please enter the address of the host", (Object)"127.0.0.1:12000");
                String[] args = ans.split(":");
                ClientMode cm = new ClientMode();
                if (cm.initialize(Mainmenu.this.gc, args[0], Integer.parseInt(args[1]))) {
                    new Thread(cm).start();
                    Mainmenu.this.gc.setCmode(cm);
                    Mainmenu.this.menu_File.setEnabled(false);
                    Mainmenu.this.menu_Entities.setEnabled(false);
                    Mainmenu.this.menu_Environment.setEnabled(false);
                    Mainmenu.this.mi_Play.setEnabled(false);
                    Mainmenu.this.mi_Host.setEnabled(false);
                    Mainmenu.this.mi_Connect.setEnabled(false);
                    Mainmenu.this.mi_Disconnect.setEnabled(true);
                    Mainmenu.this.gc.getChatdisplay().addConsoleLine("Connection established.");
                } else {
                    Mainmenu.this.gc.setClient(false);
                    Mainmenu.this.gc.getChatdisplay().addConsoleLine("Couldn't establish connection to server.");
                }
            } else {
                Mainmenu.this.gc.getChatdisplay().addConsoleLine("Already connected.");
            }
        }
    }

    private class Action_Network_Disconnect
    implements ActionListener {
        public Action_Network_Disconnect(Mainmenu m) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Mainmenu.this.gc.isClient() || Mainmenu.this.gc.isServer()) {
                if (Mainmenu.this.gc.isServer()) {
                    Mainmenu.this.gc.getSmode().shutDown();
                    Mainmenu.this.mi_Push.setEnabled(false);
                    Mainmenu.this.mi_Disconnect.setEnabled(false);
                    Mainmenu.this.mi_Host.setEnabled(true);
                    Mainmenu.this.mi_Connect.setEnabled(true);
                    Mainmenu.this.mi_Disconnect.setEnabled(false);
                }
                if (Mainmenu.this.gc.isClient()) {
                    Mainmenu.this.gc.getCmode().sendDisc();
                    Mainmenu.this.menu_File.setEnabled(true);
                    Mainmenu.this.menu_Entities.setEnabled(true);
                    Mainmenu.this.menu_Environment.setEnabled(true);
                    Mainmenu.this.mi_Play.setEnabled(true);
                    Mainmenu.this.mi_Host.setEnabled(true);
                    Mainmenu.this.mi_Connect.setEnabled(true);
                    Mainmenu.this.mi_Disconnect.setEnabled(false);
                }
                Mainmenu.this.gc.getChatdisplay().addConsoleLine("Connection closed");
            } else {
                Mainmenu.this.gc.getChatdisplay().addConsoleLine("No connection.");
            }
        }
    }

    private class Action_Network_Host
    implements ActionListener {
        public Action_Network_Host(Mainmenu m) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Mainmenu.this.gc.getRenderer().setPaused(true);
            if (!Mainmenu.this.gc.isClient() && !Mainmenu.this.gc.isServer()) {
                String ans = JOptionPane.showInputDialog("What Username would you prefer?", (Object)"DefaultUser");
                Mainmenu.this.gc.getUser().setUsername(ans);
                ArrayList<User> temp = new ArrayList<User>();
                Mainmenu.this.gc.getUser().setUid(0);
                Mainmenu.this.gc.getUser().setRank(5);
                temp.add(Mainmenu.this.gc.getUser());
                Mainmenu.this.gc.getChatdisplay().getCu().setUsers(temp);
                ServerMode sm = new ServerMode();
                ans = JOptionPane.showInputDialog("Please enter the port to host", (Object)"12000");
                if (sm.initialize(Mainmenu.this.gc, Integer.parseInt(ans))) {
                    new Thread(sm).start();
                    Mainmenu.this.gc.setSmode(sm);
                    Mainmenu.this.mi_Host.setEnabled(false);
                    Mainmenu.this.mi_Connect.setEnabled(false);
                    Mainmenu.this.mi_Push.setEnabled(true);
                    Mainmenu.this.mi_Disconnect.setEnabled(true);
                    Mainmenu.this.gc.getChatdisplay().addConsoleLine("Server established.");
                } else {
                    Mainmenu.this.gc.setServer(false);
                    Mainmenu.this.gc.getChatdisplay().addConsoleLine("Couldn't create server.");
                }
            } else {
                Mainmenu.this.gc.getChatdisplay().addConsoleLine("Already connected.");
            }
        }
    }

    private class Action_Network_PushPhysics
    implements ActionListener {
        public Action_Network_PushPhysics(Mainmenu m) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Mainmenu.this.pushPhys();
        }
    }

    private class Action_New
    implements ActionListener {
        Mainmenu menu;

        public Action_New(Mainmenu m) {
            this.menu = m;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = this.menu.getGc().getEntities().size() - 1;
            while (i >= 0) {
                this.menu.getGc().getEntities().remove(i);
                --i;
            }
        }
    }

    private class Action_Open
    implements ActionListener {
        Mainmenu menu;

        public Action_Open(Mainmenu m) {
            this.menu = m;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = new JFileChooser();
            fc.setDialogType(0);
            fc.setFileFilter(new BifrostFileFilter());
            int returnVal = fc.showOpenDialog(this.menu);
            if (returnVal == 0) {
                File f = fc.getSelectedFile();
                FileHandler fh = new FileHandler(this.menu.getGc());
                fh.open(f);
            }
        }
    }

    private class Action_Play
    implements ActionListener {
        Mainmenu menu;

        public Action_Play(Mainmenu m) {
            this.menu = m;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.menu.getMi_PlayPause().getText().equalsIgnoreCase("play")) {
                this.menu.notifyRunning();
                if (Mainmenu.this.gc.isServer()) {
                    BifrostPayload pyld = new BifrostPayload();
                    pyld.setPyld(3);
                    Mainmenu.this.gc.getSmode().getServer().send(pyld);
                }
                this.menu.getGc().getRenderer().play();
            } else {
                this.menu.notifyPaused();
                if (Mainmenu.this.gc.isServer()) {
                    BifrostPayload pyld = new BifrostPayload();
                    pyld.setPyld(4);
                    Mainmenu.this.gc.getSmode().getServer().send(pyld);
                }
                this.menu.getGc().getRenderer().stop();
            }
        }
    }

    private class Action_Save
    implements ActionListener {
        Mainmenu menu;

        public Action_Save(Mainmenu m) {
            this.menu = m;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = new JFileChooser();
            fc.setDialogType(1);
            fc.setFileFilter(new BifrostFileFilter());
            int returnVal = fc.showSaveDialog(this.menu);
            if (returnVal == 0) {
                File f = fc.getSelectedFile();
                if (!f.getName().contains(".")) {
                    f = new File(String.valueOf(f.getAbsolutePath()) + ".bpf");
                }
                FileHandler fh = new FileHandler(this.menu.getGc());
                fh.save(f);
            }
        }
    }
}

