/*
 * Decompiled with CFR 0.152.
 */
package org.abs.bifrost.gui.chat;

import java.io.Serializable;

public class User
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int RANK_OPERATOR = 5;
    public static final int RANK_MODERATOR = 4;
    public static final int RANK_HALFMODERATOR = 3;
    public static final int RANK_VOICE = 2;
    public static final int RANK_DEFAULT = 1;
    public static final int RANK_MUTED = 0;
    private int uid;
    private Integer rank;
    private String username;

    public User(int uid, String username) {
        this.uid = uid;
        this.username = username;
        this.rank = 1;
    }

    public User(int uid, String username, int rank) {
        this.uid = uid;
        this.username = username;
        this.rank = rank;
    }

    public User(User u) {
        this.uid = u.getUid();
        this.username = u.getUsername();
        this.rank = u.getRank();
    }

    public int getUid() {
        return this.uid;
    }

    public void setUid(int uid) {
        this.uid = uid;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = new Integer(rank);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String toString() {
        String ret = this.username;
        switch (this.rank) {
            case 5: {
                ret = "&" + ret;
                break;
            }
            case 4: {
                ret = "@" + ret;
                break;
            }
            case 3: {
                ret = "%" + ret;
                break;
            }
            case 2: {
                ret = "+" + ret;
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                ret = ":X " + ret;
            }
        }
        return ret;
    }

    public void setTo(User u) {
        this.rank = u.getRank();
        this.uid = u.getUid();
        this.username = u.getUsername();
    }
}

