/*
 * Decompiled with CFR 0.152.
 */
package org.abs.bifrost.tcpip;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import org.abs.bifrost.GroundControl;
import org.abs.bifrost.tcpip.BifrostPayload;
import org.abs.bifrost.tcpip.InputHandler;
import org.abs.bifrost.tcpip.OutputHandler;
import org.abs.bifrost.tcpip.TransferPayload;

public class Client
implements Runnable {
    private Socket socket;
    private TransferPayload inPayload;
    private TransferPayload outPayload;
    private GroundControl gc;
    private Thread inputThread;
    private Thread outputThread;
    private OutputHandler oh;
    private InputHandler ih;
    private int uid;

    public Client(int uid, Socket s, TransferPayload in) {
        this.uid = uid;
        this.socket = s;
        this.inPayload = in;
        this.outPayload = new TransferPayload();
        this.oh = null;
        try {
            this.oh = new OutputHandler(this.outPayload, new ObjectOutputStream(this.socket.getOutputStream()));
        }
        catch (IOException e) {
            this.gc.getChatdisplay().addConsoleLine("Could not create output stream.");
            e.printStackTrace();
        }
        this.ih = null;
        try {
            this.ih = new InputHandler(this.inPayload, new ObjectInputStream(this.socket.getInputStream()));
        }
        catch (IOException e) {
            this.gc.getChatdisplay().addConsoleLine("Could not create input stream.");
            e.printStackTrace();
        }
        this.inputThread = new Thread(this.ih);
        this.outputThread = new Thread(this.oh);
        this.inputThread.start();
        this.outputThread.start();
    }

    public int getUid() {
        return this.uid;
    }

    public void setUid(int uid) {
        this.uid = uid;
    }

    public void send(BifrostPayload bpyld) {
        this.outPayload.putPayload(bpyld);
    }

    @Override
    public void run() {
    }
}

