/*
 * Decompiled with CFR 0.152.
 */
package org.abs.bifrost.tcpip;

import java.util.ArrayList;
import org.abs.bifrost.GroundControl;
import org.abs.bifrost.gui.chat.User;
import org.abs.bifrost.tcpip.BifrostPayload;
import org.abs.bifrost.tcpip.Client;
import org.abs.bifrost.tcpip.TransferPayload;

public class Server
implements Runnable {
    private TransferPayload inPayload;
    private GroundControl gc;
    private ArrayList<Client> clients;
    private boolean initialized;

    public Server(GroundControl gc, TransferPayload in, ArrayList<Client> clients) {
        this.inPayload = in;
        this.gc = gc;
        this.clients = clients;
    }

    public void parsePayload(BifrostPayload bpyld) {
        switch (bpyld.getPyld()) {
            case 5: {
                this.chatAdd(bpyld);
                break;
            }
            case 0: {
                this.chatUser(bpyld);
                break;
            }
            case 6: {
                this.disconnect(bpyld);
            }
        }
    }

    public void shutDown() {
        this.initialized = false;
        int i = 0;
        while (i < this.clients.size()) {
            this.gc.getChatdisplay().getCu().delUser(this.clients.get(i).getUid());
            ++i;
        }
        this.clients = new ArrayList();
    }

    private void chatUser(BifrostPayload bpyld) {
        this.gc.getChatdisplay().getCu().addUser(new User(bpyld.getUser()));
        BifrostPayload newUserlist = new BifrostPayload();
        newUserlist.setPyld(0);
        newUserlist.pack(this.gc.getChatdisplay().getCu().getUsers());
        this.send(newUserlist);
    }

    private void disconnect(BifrostPayload bpyld) {
        this.gc.getChatdisplay().getCu().delUser(bpyld.getUser().getUid());
        int i = 0;
        while (i < this.clients.size()) {
            if (this.clients.get(i).getUid() == bpyld.getUser().getUid()) {
                this.clients.get(i).send(bpyld);
                this.clients.remove(i);
                break;
            }
            ++i;
        }
        BifrostPayload newUserlist = new BifrostPayload();
        newUserlist.setPyld(0);
        newUserlist.pack(this.gc.getChatdisplay().getCu().getUsers());
        BifrostPayload dcmessage = new BifrostPayload();
        dcmessage.setPyld(7);
        dcmessage.pack(String.valueOf(bpyld.getUser().getUsername()) + " disconnected from the server.");
        this.send(newUserlist);
        this.send(dcmessage);
    }

    private void chatAdd(BifrostPayload bpyld) {
        this.gc.getChatdisplay().addLine(bpyld.getChat_add(), bpyld.getUser());
        this.send(bpyld);
    }

    public void send(BifrostPayload pyld) {
        System.out.println("Sent payload type " + pyld.getPyld());
        for (Client c : this.clients) {
            c.send(pyld);
        }
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void run() {
        BifrostPayload bpyld = null;
        while (this.initialized) {
            if (this.clients.size() <= 0) continue;
            bpyld = this.inPayload.getPayload();
            this.parsePayload(bpyld);
        }
        System.out.println("Server Server not initialized");
    }
}

