/*
 * Decompiled with CFR 0.152.
 */
package org.abs.bifrost.tcpip;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import org.abs.bifrost.GroundControl;
import org.abs.bifrost.tcpip.BifrostPayload;
import org.abs.bifrost.tcpip.Client;
import org.abs.bifrost.tcpip.Server;
import org.abs.bifrost.tcpip.TransferPayload;

public class ServerMode
implements Runnable {
    private ServerSocket ssocket;
    private TransferPayload inPayload = new TransferPayload();
    private GroundControl gc;
    private boolean initialized = false;
    private ArrayList<Client> clients = new ArrayList();
    private Server server;
    private int uid = 50;

    public boolean initialize(GroundControl gc, int port) {
        this.gc = gc;
        gc.setServer(true);
        this.server = new Server(gc, this.inPayload, this.clients);
        try {
            this.ssocket = new ServerSocket(port);
        }
        catch (IOException e) {
            gc.getChatdisplay().addConsoleLine("Couldn't create server.");
            e.printStackTrace();
        }
        this.server.setInitialized(true);
        new Thread(this.server).start();
        this.initialized = true;
        return true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public Server getServer() {
        return this.server;
    }

    public void shutDown() {
        BifrostPayload bp = new BifrostPayload();
        bp.setPyld(6);
        this.server.send(bp);
        this.initialized = false;
        this.server.shutDown();
        try {
            this.ssocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.gc.getChatdisplay().addConsoleLine("Server shut down.");
        this.gc.setServer(false);
    }

    @Override
    public void run() {
        while (this.initialized) {
            try {
                Socket temp = this.ssocket.accept();
                Client cl = new Client(this.uid, temp, this.inPayload);
                this.clients.add(cl);
                BifrostPayload initPayload = new BifrostPayload();
                initPayload.pack(this.uid);
                initPayload.setPyld(-1);
                cl.send(initPayload);
                ++this.uid;
            }
            catch (IOException e) {
                this.gc.getChatdisplay().addConsoleLine("Couldn't connect to client.");
                e.printStackTrace();
            }
        }
        System.out.println("Server not initialized");
    }
}

