/*
 * Decompiled with CFR 0.152.
 */
package org.abs.bifrost.entities;

import java.awt.Color;
import java.util.ArrayList;
import org.abs.bifrost.GroundControl;
import org.abs.bifrost.entities.Ball;
import org.abs.bifrost.entities.Entity;
import org.abs.bifrost.physics.Vector;

public class Generator {
    private static final int TRYLIMIT = 400;

    public static void random_scaled(GroundControl gc, int amount, double min_mass, double max_mass, double max_velocity) {
        int expected_amount = gc.getEntities().size() + amount;
        int generated = 0;
        int tryno = 0;
        while (gc.getEntities().size() != expected_amount) {
            ++tryno;
            Vector position = new Vector(Generator.nonZeroRandom() * gc.getEnvironmentWidth(), Generator.nonZeroRandom() * gc.getEnvironmentHeight());
            while (!Generator.verifyLocation(position, gc)) {
                position = new Vector(Generator.nonZeroRandom() * gc.getEnvironmentWidth(), Generator.nonZeroRandom() * gc.getEnvironmentHeight());
            }
            Ball genball = new Ball();
            genball.setName("Generated Entity " + generated);
            genball.setPosition(position);
            genball.setColor(new Color((int)(Generator.nonZeroRandom() * 255.0), (int)(Generator.nonZeroRandom() * 255.0), (int)(Generator.nonZeroRandom() * 255.0), 255));
            if (min_mass == max_mass) {
                genball.setMass(max_mass);
            } else {
                genball.setMass(Generator.nonZeroRandom() * max_mass);
                while (genball.getMass() < 1.0 | genball.getMass() < min_mass) {
                    genball.setMass(Generator.nonZeroRandom() * max_mass);
                }
            }
            genball.setRadius(genball.getMass());
            genball.setVelocity(new Vector(Generator.nonZeroRandom() * max_velocity, Generator.nonZeroRandom() * max_velocity));
            if (Generator.noCollision(genball, gc)) {
                genball.updateShape();
                genball.setFinecircles(gc.isFinecircles());
                gc.getEntities().add(genball);
                ++generated;
                tryno = 0;
                continue;
            }
            if (tryno != 400) continue;
            gc.getChatdisplay().addConsoleLine("Error while generating entity " + (generated + 1) + ", terminating generation.");
            break;
        }
        gc.getChatdisplay().addConsoleLine("Generated " + generated + " entities.");
    }

    public static void random(GroundControl gc, int amount, double min_mass, double max_mass, double max_radius, double max_velocity) {
        int expected_amount = gc.getEntities().size() + amount;
        int generated = 0;
        int tryno = 0;
        while (gc.getEntities().size() != expected_amount) {
            ++tryno;
            Vector position = new Vector(Generator.nonZeroRandom() * gc.getEnvironmentWidth(), Generator.nonZeroRandom() * gc.getEnvironmentHeight());
            while (!Generator.verifyLocation(position, gc)) {
                position = new Vector(Generator.nonZeroRandom() * gc.getEnvironmentWidth(), Generator.nonZeroRandom() * gc.getEnvironmentHeight());
            }
            Ball genball = new Ball();
            genball.setName("Generated Entity " + generated);
            genball.setPosition(position);
            genball.setColor(new Color((int)(Generator.nonZeroRandom() * 255.0), (int)(Generator.nonZeroRandom() * 255.0), (int)(Generator.nonZeroRandom() * 255.0), 255));
            if (min_mass == max_mass) {
                genball.setMass(max_mass);
            } else {
                genball.setMass(Generator.nonZeroRandom() * max_mass);
                while (genball.getMass() < 1.0 | genball.getMass() < min_mass) {
                    genball.setMass(Generator.nonZeroRandom() * max_mass);
                }
            }
            genball.setRadius(Generator.nonZeroRandom() * max_radius);
            while (genball.getRadius() < 1.0) {
                genball.setRadius(Generator.nonZeroRandom() * max_radius);
            }
            genball.setVelocity(new Vector(Generator.nonZeroRandom() * max_velocity, Generator.nonZeroRandom() * max_velocity));
            if (Generator.noCollision(genball, gc)) {
                genball.updateShape();
                genball.setFinecircles(gc.isFinecircles());
                gc.getEntities().add(genball);
                ++generated;
                tryno = 0;
                continue;
            }
            if (tryno != 400) continue;
            gc.getChatdisplay().addConsoleLine("Error while generating entity " + (generated + 1) + ", terminating generation.");
            break;
        }
        gc.getChatdisplay().addConsoleLine("Generated " + generated + " entities.");
    }

    public static void column(GroundControl gc, int amount, double xaxis, double mass) {
        int expected_amount = gc.getEntities().size() + amount;
        int generated = 0;
        int tryno = 0;
        while (gc.getEntities().size() != expected_amount) {
            ++tryno;
            Vector position = new Vector(xaxis, Generator.nonZeroRandom() * gc.getEnvironmentHeight());
            while (!Generator.verifyLocation(position, gc)) {
                position = new Vector(xaxis, Generator.nonZeroRandom() * gc.getEnvironmentHeight());
            }
            Ball genball = new Ball();
            genball.setName("Generated Entity " + generated);
            genball.setPosition(position);
            genball.setColor(new Color((int)(Generator.nonZeroRandom() * 255.0), (int)(Generator.nonZeroRandom() * 255.0), (int)(Generator.nonZeroRandom() * 255.0), 255));
            genball.setMass(mass);
            genball.setRadius(mass);
            genball.setVelocity(new Vector());
            while (!Generator.noCollision(genball, gc)) {
                if (genball.getRadius() < 1.0) break;
                genball.setRadius(genball.getRadius() - 0.1);
            }
            if (Generator.noCollision(genball, gc)) {
                genball.updateShape();
                genball.setFinecircles(gc.isFinecircles());
                gc.getEntities().add(genball);
                ++generated;
                tryno = 0;
                continue;
            }
            if (tryno != 400) continue;
            gc.getChatdisplay().addConsoleLine("Error while generating entity " + (generated + 1) + ", terminating generation.");
            break;
        }
        gc.getChatdisplay().addConsoleLine("Generated " + generated + " entities.");
    }

    public static void row(GroundControl gc, int amount, double yaxis, double mass) {
        int expected_amount = gc.getEntities().size() + amount;
        int generated = 0;
        int tryno = 0;
        while (gc.getEntities().size() != expected_amount) {
            ++tryno;
            Vector position = new Vector(Generator.nonZeroRandom() * gc.getEnvironmentWidth(), yaxis);
            while (!Generator.verifyLocation(position, gc)) {
                position = new Vector(Generator.nonZeroRandom() * gc.getEnvironmentWidth(), yaxis);
            }
            Ball genball = new Ball();
            genball.setName("Generated Entity " + generated);
            genball.setPosition(position);
            genball.setColor(new Color((int)(Generator.nonZeroRandom() * 255.0), (int)(Generator.nonZeroRandom() * 255.0), (int)(Generator.nonZeroRandom() * 255.0), 255));
            genball.setMass(mass);
            genball.setRadius(mass);
            genball.setVelocity(new Vector());
            while (!Generator.noCollision(genball, gc)) {
                if (genball.getRadius() < 1.0) break;
                genball.setRadius(genball.getRadius() - 0.1);
            }
            if (Generator.noCollision(genball, gc)) {
                genball.updateShape();
                genball.setFinecircles(gc.isFinecircles());
                gc.getEntities().add(genball);
                ++generated;
                tryno = 0;
                continue;
            }
            if (tryno != 400) continue;
            gc.getChatdisplay().addConsoleLine("Error while generating entity " + (generated + 1) + ", terminating generation.");
            break;
        }
        gc.getChatdisplay().addConsoleLine("Generated " + generated + " entities.");
    }

    public static void squareLattice(GroundControl gc, int amount, Vector vertex1, Vector vertex2, double mass) {
        int generated = 0;
        double x = Math.abs(vertex1.getX() - vertex2.getX());
        double y = Math.abs(vertex1.getY() - vertex2.getY());
        double radiusofball = Math.sqrt(x * y / (double)amount) / 2.0;
        int rowcount = (int)(y / (radiusofball * 2.0));
        int columncount = (int)(x / (radiusofball * 2.0));
        Vector currpos = new Vector(vertex1);
        currpos.add(new Vector(radiusofball, radiusofball));
        int j = 0;
        while (j < rowcount) {
            currpos.setX(vertex1.getX() + radiusofball);
            int i = 0;
            while (i < columncount) {
                Ball genball = new Ball();
                genball.setPosition(new Vector(currpos));
                genball.setMass(mass);
                genball.setName("Generated Entity " + generated);
                genball.setColor(new Color((int)(Generator.nonZeroRandom() * 255.0), (int)(Generator.nonZeroRandom() * 255.0), (int)(Generator.nonZeroRandom() * 255.0), 255));
                genball.setRadius(radiusofball - 1.0E-9);
                genball.setFinecircles(gc.isFinecircles());
                gc.getEntities().add(genball);
                ++generated;
                currpos.setX(currpos.getX() + radiusofball * 2.0);
                ++i;
            }
            currpos.setY(currpos.getY() + radiusofball * 2.0);
            ++j;
        }
        gc.getChatdisplay().addConsoleLine("Generated " + generated + " entities.");
    }

    public static void line(GroundControl gc, ArrayList<Vector> line, double mass, double radius) {
        int generated = 0;
        for (Vector v : line) {
            Vector position = v;
            if (!Generator.verifyLocation(position, gc)) continue;
            Ball genball = new Ball();
            genball.setName("Generated Entity " + generated);
            genball.setPosition(position);
            genball.setColor(new Color((int)(Generator.nonZeroRandom() * 255.0), (int)(Generator.nonZeroRandom() * 255.0), (int)(Generator.nonZeroRandom() * 255.0), 255));
            genball.setMass(mass);
            genball.setRadius(radius);
            genball.setVelocity(new Vector());
            if (!Generator.noCollision(genball, gc)) continue;
            genball.updateShape();
            genball.setFinecircles(gc.isFinecircles());
            gc.getEntities().add(genball);
            ++generated;
        }
        gc.getChatdisplay().addConsoleLine("Generated " + generated + " entities.");
    }

    public static boolean verifyLocation(Vector v, GroundControl gc) {
        for (Entity h : gc.getEntities()) {
            if (!h.getPosition().equals(v)) continue;
            return false;
        }
        return true;
    }

    public static boolean noCollision(Ball b, GroundControl gc) {
        boolean cont;
        boolean bl = cont = b.getPosition().getY() + b.getRadius() < gc.getEnvironmentHeight();
        boolean bl2 = cont ? b.getPosition().getY() - b.getRadius() > 0.0 : (cont = false);
        boolean bl3 = cont ? b.getPosition().getX() - b.getRadius() > 0.0 : (cont = false);
        boolean bl4 = cont ? b.getPosition().getX() + b.getRadius() < gc.getEnvironmentWidth() : (cont = false);
        if (!cont) {
            return false;
        }
        for (Entity ent : gc.getEntities()) {
            Vector direction = new Vector(ent.getPosition().getX() - b.getPosition().getX(), ent.getPosition().getY() - b.getPosition().getY());
            if (!(direction.getR() <= ((Ball)ent).getRadius() + b.getRadius())) continue;
            return false;
        }
        return true;
    }

    public static boolean noCollision(Vector v, Ball b, GroundControl gc) {
        Vector direction = new Vector(b.getPosition().getX() - v.getX(), b.getPosition().getY() - v.getY());
        return !(direction.getR() <= b.getRadius());
    }

    public static double nonZeroRandom() {
        double r = Math.random();
        while (r == 0.0) {
            r = Math.random();
        }
        return r;
    }
}

