/*
 * Decompiled with CFR 0.152.
 */
package org.abs.bifrost.fileio;

import java.awt.Color;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Scanner;
import org.abs.bifrost.Environment;
import org.abs.bifrost.GroundControl;
import org.abs.bifrost.entities.Ball;
import org.abs.bifrost.entities.Entity;

public class BPFileHandler {
    private GroundControl gc;
    public static final int BALL_NAME = 1;
    public static final int BALL_RADIUS = 3;
    public static final int BALL_MASS = 5;
    public static final int BALL_CHARGE = 7;
    public static final int BALL_DRAGC = 9;
    public static final int BALL_POS_X = 11;
    public static final int BALL_POS_Y = 13;
    public static final int BALL_VEL_X = 15;
    public static final int BALL_VEL_Y = 17;
    public static final int BALL_COL_R = 19;
    public static final int BALL_COL_G = 21;
    public static final int BALL_COL_B = 23;
    public static final int BALL_COL_A = 25;
    public static final int BALL_TRACELIMIT = 27;
    public static final int BALL_TRACE = 29;
    public static final int BALL_COLLIDABLE = 31;
    public static final int BALL_PINNED = 33;
    public static final int BALL_DRAW_V = 35;
    public static final int BALL_FABULOUS = 37;
    public static final int ENVIRONMENT_GRAVITY_X = 1;
    public static final int ENVIRONMENT_GRAVITY_Y = 3;
    public static final int ENVIRONMENT_PPM = 5;
    public static final int ENVIRONMENT_FLUID_DENSITY = 7;
    public static final int ENVIRONMENT_E_X = 9;
    public static final int ENVIRONMENT_E_Y = 11;
    public static final int GC_AMBIENTGRAVITY = 1;
    public static final int GC_MUTUALGRAVITY = 3;
    public static final int GC_FLUIDICRESISTANCE = 5;
    public static final int GC_TOPBOUNCE = 7;
    public static final int GC_RIGHTBOUNCE = 9;
    public static final int GC_BOTTOMBOUNCE = 11;
    public static final int GC_LEFTBOUNCE = 13;
    public static final int GC_MUTUALELECTRIC = 15;
    public static final int GC_TIMESTEP = 17;

    public BPFileHandler(GroundControl gc) {
        this.gc = gc;
    }

    public void open(File f) {
        Scanner sc = null;
        try {
            sc = (Scanner)this.openFile(f, 'r');
        }
        catch (Exception e) {
            this.gc.getChatdisplay().addConsoleLine("Open failed.");
            return;
        }
        this.gc.getEntities().clear();
        this.readFrom(sc);
        this.gc.getChatdisplay().addConsoleLine("Opened file.");
        sc.close();
    }

    public void save(File f) {
        PrintWriter pw = null;
        try {
            pw = (PrintWriter)this.openFile(f, 'w');
        }
        catch (Exception e) {
            this.gc.getChatdisplay().addConsoleLine("Save failed.");
            return;
        }
        this.writeTo(pw);
        this.gc.getChatdisplay().addConsoleLine("Saved.");
        pw.close();
    }

    public void writeTo(PrintWriter pw) {
        pw.println(this.exportGroundcontrol());
        pw.println(this.exportEnvironment(this.gc.getEnv()));
        for (Entity e : this.gc.getEntities()) {
            pw.println(this.exportBall((Ball)e));
        }
        pw.flush();
    }

    private Object openFile(File f, char readwrite) throws Exception {
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                this.gc.getChatdisplay().addConsoleLine("Couldn't open file: " + f.getAbsolutePath());
                e.printStackTrace();
                throw e;
            }
        }
        Closeable ret = null;
        if (readwrite == 'w') {
            try {
                ret = new PrintWriter(f);
            }
            catch (Exception e) {
                this.gc.getChatdisplay().addConsoleLine("Couldn't create print writer!");
                e.printStackTrace();
                throw e;
            }
        } else if (readwrite == 'r') {
            try {
                ret = new Scanner(f);
            }
            catch (Exception e) {
                this.gc.getChatdisplay().addConsoleLine("Couldn't create scanner!");
                e.printStackTrace();
                throw e;
            }
        } else {
            this.gc.getChatdisplay().addConsoleLine("Unrecognized read write option.");
            throw new Exception();
        }
        return ret;
    }

    public void readFrom(Scanner sc) {
        String currentobject = "";
        boolean inBall = false;
        boolean inEnv = false;
        boolean inGc = false;
        Environment currenv = null;
        Ball currball = null;
        while (sc.hasNextLine()) {
            String currentline = sc.nextLine();
            if (currentline.isEmpty() || currentline.charAt(0) == '#') continue;
            if (currentline.charAt(0) == '}') {
                if (inBall) {
                    currball = this.readBall(currentobject);
                    currentobject = "";
                    this.gc.getEntities().add(currball);
                    inBall = false;
                    continue;
                }
                if (inEnv) {
                    currenv = this.readEnv(currentobject);
                    currentobject = "";
                    this.gc.setEnv(currenv);
                    inEnv = false;
                    continue;
                }
                if (!inGc) continue;
                this.readGc(currentobject);
                currentobject = "";
                inGc = false;
                continue;
            }
            if (currentline.contains("{")) {
                String[] sarray = currentline.split(" ");
                if (sarray[0].equalsIgnoreCase("Entity:Ball")) {
                    inBall = true;
                    continue;
                }
                if (sarray[0].equalsIgnoreCase("Groundcontrol")) {
                    inGc = true;
                    continue;
                }
                if (!sarray[0].equalsIgnoreCase("Environment")) continue;
                inEnv = true;
                continue;
            }
            if (!(inBall | inEnv | inGc)) continue;
            currentobject = String.valueOf(currentobject) + currentline;
        }
    }

    public void readFromArrayList(ArrayList<String> s) {
        this.gc.getEntities().clear();
        String currentobject = "";
        boolean inBall = false;
        boolean inEnv = false;
        boolean inGc = false;
        Environment currenv = null;
        Ball currball = null;
        for (String st : s) {
            String currentline = st;
            if (currentline.isEmpty() || currentline.charAt(0) == '#') continue;
            if (currentline.charAt(0) == '}') {
                if (inBall) {
                    currball = this.readBall(currentobject);
                    currentobject = "";
                    this.gc.getEntities().add(currball);
                    inBall = false;
                    continue;
                }
                if (inEnv) {
                    currenv = this.readEnv(currentobject);
                    currentobject = "";
                    this.gc.setEnv(currenv);
                    inEnv = false;
                    continue;
                }
                if (!inGc) continue;
                this.readGc(currentobject);
                currentobject = "";
                inGc = false;
                continue;
            }
            if (currentline.contains("{")) {
                String[] sarray = currentline.split(" ");
                if (sarray[0].equalsIgnoreCase("Entity:Ball")) {
                    inBall = true;
                    continue;
                }
                if (sarray[0].equalsIgnoreCase("Groundcontrol")) {
                    inGc = true;
                    continue;
                }
                if (!sarray[0].equalsIgnoreCase("Environment")) continue;
                inEnv = true;
                continue;
            }
            if (!(inBall | inEnv | inGc)) continue;
            currentobject = String.valueOf(currentobject) + currentline;
        }
    }

    public String exportBall(Ball e) {
        String ret = "Entity:Ball {\n\r";
        ret = String.valueOf(ret) + "\tName:" + e.getName() + "\n\r";
        ret = String.valueOf(ret) + "\tRadius:" + e.getRadius() + "\n\r";
        ret = String.valueOf(ret) + "\tMass:" + e.getMass() + "\n\r";
        ret = String.valueOf(ret) + "\tCharge:" + e.getCharge() + "\n\r";
        ret = String.valueOf(ret) + "\tDragC:" + e.getDrag_coefficient() + "\n\r";
        ret = String.valueOf(ret) + "\tPosX:" + e.getPosition().getX() + "\n\r";
        ret = String.valueOf(ret) + "\tPosY:" + e.getPosition().getY() + "\n\r";
        ret = String.valueOf(ret) + "\tVelX:" + e.getVelocity().getX() + "\n\r";
        ret = String.valueOf(ret) + "\tVelY:" + e.getVelocity().getY() + "\n\r";
        ret = String.valueOf(ret) + "\tColR:" + e.getColor().getRed() + "\n\r";
        ret = String.valueOf(ret) + "\tColG:" + e.getColor().getGreen() + "\n\r";
        ret = String.valueOf(ret) + "\tColB:" + e.getColor().getBlue() + "\n\r";
        ret = String.valueOf(ret) + "\tColA:" + e.getColor().getAlpha() + "\n\r";
        ret = String.valueOf(ret) + "\tTracelimit:" + e.getTracelimit() + "\n\r";
        ret = String.valueOf(ret) + "\tTrace:" + e.isTrace() + "\n\r";
        ret = String.valueOf(ret) + "\tCollidable:" + e.isCollidable() + "\n\r";
        ret = String.valueOf(ret) + "\tPinned:" + e.isPinned() + "\n\r";
        ret = String.valueOf(ret) + "\tDraw Velocities:" + e.isDrawVelocity() + "\n\r";
        ret = String.valueOf(ret) + "\tFabulous:" + e.isFabulous() + "\n\r";
        ret = String.valueOf(ret) + "}\n\r";
        return ret;
    }

    public String exportEnvironment(Environment e) {
        String ret = "Environment {\n\r";
        ret = String.valueOf(ret) + "\tGravityX:" + e.getGravity().getX() + "\n\r";
        ret = String.valueOf(ret) + "\tGravityY:" + e.getGravity().getY() + "\n\r";
        ret = String.valueOf(ret) + "\tPPM:" + e.getppm() + "\n\r";
        ret = String.valueOf(ret) + "\tFluid Density:" + e.getFluidDensity() + "\n\r";
        ret = String.valueOf(ret) + "\tEFieldX:" + e.getEfield().getX() + "\n\r";
        ret = String.valueOf(ret) + "\tEFieldY:" + e.getEfield().getY() + "\n\r";
        ret = String.valueOf(ret) + "}\r\n";
        return ret;
    }

    public String exportGroundcontrol() {
        String ret = "Groundcontrol {\n\r";
        ret = String.valueOf(ret) + "\tGravity:" + this.gc.isAmbientgravity() + "\n\r";
        ret = String.valueOf(ret) + "\tMutual Gravitation:" + this.gc.isGravity() + "\n\r";
        ret = String.valueOf(ret) + "\tFluidic Resistance:" + this.gc.isFluidResistance() + "\n\r";
        ret = String.valueOf(ret) + "\tTop Bounce:" + this.gc.isTopBounce() + "\n\r";
        ret = String.valueOf(ret) + "\tRight Bounce:" + this.gc.isRightBounce() + "\n\r";
        ret = String.valueOf(ret) + "\tBottom Bounce:" + this.gc.isBottomBounce() + "\n\r";
        ret = String.valueOf(ret) + "\tLeft Bounce:" + this.gc.isLeftBounce() + "\n\r";
        ret = String.valueOf(ret) + "\tMutual Electric:" + this.gc.isMutualelectric() + "\n\r";
        ret = String.valueOf(ret) + "\tTimestep:" + this.gc.getTimeStep() + "\n\r";
        ret = String.valueOf(ret) + "}\r\n";
        return ret;
    }

    public Ball readBall(String s) {
        Ball ret = new Ball();
        if ((s = s.replaceAll("\t", ":")).charAt(0) == ':') {
            s = s.substring(1);
        }
        String[] data = s.split(":");
        ret.setName(data[1]);
        ret.setRadius(Double.parseDouble(data[3]));
        ret.setMass(Double.parseDouble(data[5]));
        ret.setCharge(Double.parseDouble(data[7]));
        ret.getPosition().setX(Double.parseDouble(data[11]));
        ret.getPosition().setY(Double.parseDouble(data[13]));
        ret.getVelocity().setX(Double.parseDouble(data[15]));
        ret.getVelocity().setY(Double.parseDouble(data[17]));
        ret.setColor(new Color(Integer.parseInt(data[19]), Integer.parseInt(data[21]), Integer.parseInt(data[23]), Integer.parseInt(data[25])));
        ret.setTracelimit(Integer.parseInt(data[27]));
        ret.setTrace(Boolean.parseBoolean(data[29]));
        ret.setCollidable(Boolean.parseBoolean(data[31]));
        ret.setPinned(Boolean.parseBoolean(data[33]));
        ret.setDrawVelocity(Boolean.parseBoolean(data[35]));
        ret.setFabulous(Boolean.parseBoolean(data[37]));
        return ret;
    }

    public Environment readEnv(String s) {
        Environment env = new Environment();
        if ((s = s.replaceAll("\t", ":")).charAt(0) == ':') {
            s = s.substring(1);
        }
        String[] data = s.split(":");
        env.getEfield().setX(Double.parseDouble(data[9]));
        env.getEfield().setY(Double.parseDouble(data[11]));
        env.getGravity().setX(Double.parseDouble(data[1]));
        env.getGravity().setY(Double.parseDouble(data[3]));
        env.setppm(Double.parseDouble(data[5]));
        env.setFluidDensity(Double.parseDouble(data[7]));
        return env;
    }

    public void readGc(String s) {
        if ((s = s.replaceAll("\t", ":")).charAt(0) == ':') {
            s = s.substring(1);
        }
        String[] data = s.split(":");
        this.gc.setAmbientgravity(Boolean.parseBoolean(data[1]));
        this.gc.setGravity(Boolean.parseBoolean(data[3]));
        this.gc.setFluidResistance(Boolean.parseBoolean(data[5]));
        this.gc.setBorderBounce(Boolean.parseBoolean(data[7]), Boolean.parseBoolean(data[9]), Boolean.parseBoolean(data[11]), Boolean.parseBoolean(data[13]));
        this.gc.setMutualelectric(Boolean.parseBoolean(data[15]));
        this.gc.setTimeStep(Double.parseDouble(data[17]));
    }
}

