/*
 * Decompiled with CFR 0.152.
 */
package org.abs.bifrost.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.MaskFormatter;
import org.abs.bifrost.GroundControl;
import org.abs.bifrost.entities.Ball;
import org.abs.bifrost.entities.Entity;
import org.abs.bifrost.physics.Vector;

public class EntityEditor
extends JFrame {
    private static final long serialVersionUID = 1L;
    private GroundControl gc;
    private boolean isNew;
    private Ball entity;
    private JTextField field_name;
    private JTextField field_mass;
    private JTextField field_charge;
    private JTextField field_x;
    private JTextField field_y;
    private JTextField field_x_velocity;
    private JTextField field_y_velocity;
    private JTextField field_dragc;
    private JTextField field_color_r;
    private JTextField field_color_g;
    private JTextField field_color_b;
    private JTextField field_color_alpha;
    private JTextField field_radius;
    private JTextField field_tracelimit;
    private JButton button_accept;
    private JButton button_cancel;
    private JButton button_color;
    private JCheckBox checkbox_pinned;
    private JCheckBox checkbox_trace;
    private JCheckBox checkbox_collidable;
    private JCheckBox checkbox_drawvelocity;
    private Color dialog_color;

    public EntityEditor(Ball e, GroundControl gc, boolean isNew) {
        super("Entity Editor");
        this.setIconImage(gc.getIcon());
        this.gc = gc;
        this.isNew = isNew;
        this.entity = e;
        int width = 350;
        int height = 380;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screen.width - width) / 2;
        int y = (screen.height - height) / 2;
        this.setBounds(x, y, width, height);
        JPanel pnl_main = (JPanel)this.getContentPane();
        pnl_main.setPreferredSize(new Dimension(width, height));
        pnl_main.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        JLabel temp = new JLabel("Entity name: ");
        pnl_main.add((Component)temp, c);
        ++c.gridx;
        this.field_name = new JTextField();
        this.field_name.setText(e.getName());
        pnl_main.add((Component)this.field_name, c);
        c.gridx = 0;
        ++c.gridy;
        pnl_main.add((Component)new JLabel("X Coordinate: "), c);
        this.field_x = new JTextField();
        this.field_x.setText(Double.toString(e.getPosition().getX()));
        ++c.gridx;
        pnl_main.add((Component)this.field_x, c);
        ++c.gridx;
        pnl_main.add((Component)new JLabel("pixels"), c);
        c.gridx = 0;
        ++c.gridy;
        pnl_main.add((Component)new JLabel("Y Coordinate: "), c);
        this.field_y = new JTextField();
        ++c.gridx;
        this.field_y.setText(Double.toString(e.getPosition().getY()));
        pnl_main.add((Component)this.field_y, c);
        ++c.gridx;
        pnl_main.add((Component)new JLabel("pixels"), c);
        c.gridx = 0;
        ++c.gridy;
        pnl_main.add((Component)new JLabel("Mass: "), c);
        this.field_mass = new JTextField();
        this.field_mass.setText(Double.toString(e.getMass()));
        ++c.gridx;
        pnl_main.add((Component)this.field_mass, c);
        ++c.gridx;
        pnl_main.add((Component)new JLabel("kg"), c);
        c.gridx = 0;
        ++c.gridy;
        pnl_main.add((Component)new JLabel("X Velocity: "), c);
        this.field_x_velocity = new JTextField();
        this.field_x_velocity.setText(Double.toString(e.getVelocity().getX()));
        ++c.gridx;
        pnl_main.add((Component)this.field_x_velocity, c);
        ++c.gridx;
        pnl_main.add((Component)new JLabel("m/s"), c);
        c.gridx = 0;
        ++c.gridy;
        pnl_main.add((Component)new JLabel("Y Velocity: "), c);
        this.field_y_velocity = new JTextField();
        this.field_y_velocity.setText(Double.toString(e.getVelocity().getY()));
        ++c.gridx;
        pnl_main.add((Component)this.field_y_velocity, c);
        ++c.gridx;
        pnl_main.add((Component)new JLabel("m/s"), c);
        c.gridx = 0;
        ++c.gridy;
        pnl_main.add((Component)new JLabel("Charge: "), c);
        this.field_charge = new JTextField();
        this.field_charge.setText(Double.toString(e.getCharge()));
        ++c.gridx;
        pnl_main.add((Component)this.field_charge, c);
        ++c.gridx;
        pnl_main.add((Component)new JLabel("C"), c);
        c.gridx = 0;
        ++c.gridy;
        pnl_main.add((Component)new JLabel("Radius: "), c);
        this.field_radius = new JTextField();
        this.field_radius.setText(Double.toString(e.getRadius()));
        ++c.gridx;
        pnl_main.add((Component)this.field_radius, c);
        ++c.gridx;
        pnl_main.add((Component)new JLabel("pixels"), c);
        c.gridx = 0;
        ++c.gridy;
        pnl_main.add((Component)new JLabel("Drag Coefficient: "), c);
        ++c.gridx;
        this.field_dragc = new JTextField();
        this.field_dragc.setText(Double.toString(e.getDrag_coefficient()));
        pnl_main.add((Component)this.field_dragc, c);
        c.gridx = 0;
        ++c.gridy;
        pnl_main.add((Component)new JLabel("Tracelimit: "), c);
        ++c.gridx;
        this.field_tracelimit = new JTextField();
        this.field_tracelimit.setText(Double.toString(e.getTracelimit()));
        pnl_main.add((Component)this.field_tracelimit, c);
        ++c.gridx;
        pnl_main.add((Component)new JLabel("(0 is unlimited)"), c);
        c.gridx = 0;
        ++c.gridy;
        this.dialog_color = e.getColor();
        pnl_main.add((Component)new JLabel("Color (RGB): "), c);
        ++c.gridx;
        this.field_color_r = new JTextField();
        this.field_color_r.setText(Double.toString(e.getColor().getRed()));
        pnl_main.add((Component)this.field_color_r, c);
        ++c.gridx;
        this.field_color_g = new JTextField();
        this.field_color_g.setText(Double.toString(e.getColor().getGreen()));
        pnl_main.add((Component)this.field_color_g, c);
        ++c.gridx;
        this.field_color_b = new JTextField();
        this.field_color_b.setText(Double.toString(e.getColor().getBlue()));
        pnl_main.add((Component)this.field_color_b, c);
        ++c.gridx;
        this.button_color = new JButton("Pick");
        this.button_color.addActionListener(new Action_Colorpicker(this));
        pnl_main.add((Component)this.button_color, c);
        c.gridx = 0;
        ++c.gridy;
        pnl_main.add((Component)new JLabel("Alpha 0.0-1.0"), c);
        ++c.gridx;
        this.field_color_alpha = new JTextField();
        this.field_color_alpha.setText(Double.toString(e.getColor().getAlpha() / 255));
        pnl_main.add((Component)this.field_color_alpha, c);
        c.gridx = 0;
        ++c.gridy;
        this.checkbox_pinned = new JCheckBox();
        this.checkbox_pinned.setSelected(e.isPinned());
        pnl_main.add((Component)this.checkbox_pinned, c);
        ++c.gridx;
        pnl_main.add((Component)new JLabel("Pinned"), c);
        ++c.gridx;
        c.gridx = 0;
        ++c.gridy;
        this.checkbox_collidable = new JCheckBox();
        this.checkbox_collidable.setSelected(e.isCollidable());
        pnl_main.add((Component)this.checkbox_collidable, c);
        ++c.gridx;
        pnl_main.add((Component)new JLabel("Collidable"), c);
        ++c.gridx;
        c.gridx = 0;
        ++c.gridy;
        this.checkbox_trace = new JCheckBox();
        this.checkbox_trace.setSelected(e.isTrace());
        pnl_main.add((Component)this.checkbox_trace, c);
        ++c.gridx;
        pnl_main.add((Component)new JLabel("Trace"), c);
        ++c.gridx;
        c.gridx = 0;
        ++c.gridy;
        this.checkbox_drawvelocity = new JCheckBox();
        this.checkbox_drawvelocity.setSelected(e.isDrawVelocity());
        pnl_main.add((Component)this.checkbox_drawvelocity, c);
        ++c.gridx;
        pnl_main.add((Component)new JLabel("Draw Velocity"), c);
        ++c.gridx;
        c.gridx = 0;
        ++c.gridy;
        this.button_accept = new JButton("Accept");
        this.button_cancel = new JButton("Cancel");
        this.button_accept.addActionListener(new Action_Accept(this));
        this.button_cancel.addActionListener(new Action_Cancel(this));
        this.button_accept.setMnemonic(65);
        this.button_cancel.setMnemonic(67);
        pnl_main.add((Component)this.button_accept, c);
        ++c.gridx;
        pnl_main.add((Component)this.button_cancel, c);
        this.pack();
        this.setVisible(true);
    }

    public EntityEditor(MouseEvent e, GroundControl gc, boolean isNew) {
        this.gc = gc;
        Ball newBall = new Ball();
        newBall.setPosition(new Vector(e.getX(), gc.getEnvironmentHeight() - (double)e.getY()));
        new EntityEditor(newBall, gc, isNew);
    }

    public EntityEditor(GroundControl gc, boolean isNew) {
        this.gc = gc;
        Ball newBall = new Ball();
        new EntityEditor(newBall, gc, isNew);
    }

    public boolean verifyLocation(Vector v) {
        for (Entity h : this.gc.getEntities()) {
            if (!h.getPosition().equals(v) || this.getEntity() == h) continue;
            JOptionPane.showMessageDialog(null, "Can't let you do that, StarFox.\n(Entities can't have the same initial co-ordinates)", "Schr\u00f6dinger's Error", 0);
            return false;
        }
        return true;
    }

    protected MaskFormatter createFormatter(String s) {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter(s);
        }
        catch (ParseException exc) {
            System.err.println("formatter is bad: " + exc.getMessage());
            System.exit(-1);
        }
        return formatter;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public Ball getEntity() {
        return this.entity;
    }

    public JTextField getField_name() {
        return this.field_name;
    }

    public JTextField getField_mass() {
        return this.field_mass;
    }

    public JTextField getField_charge() {
        return this.field_charge;
    }

    public JTextField getField_x() {
        return this.field_x;
    }

    public JTextField getField_y() {
        return this.field_y;
    }

    public JTextField getField_x_velocity() {
        return this.field_x_velocity;
    }

    public JTextField getField_y_velocity() {
        return this.field_y_velocity;
    }

    public JTextField getField_dragc() {
        return this.field_dragc;
    }

    public JTextField getField_color_r() {
        return this.field_color_r;
    }

    public JTextField getField_color_g() {
        return this.field_color_g;
    }

    public JTextField getField_color_b() {
        return this.field_color_b;
    }

    public JTextField getField_radius() {
        return this.field_radius;
    }

    public JTextField getField_tracelimit() {
        return this.field_tracelimit;
    }

    public Color getDialog_color() {
        return this.dialog_color;
    }

    public GroundControl getGc() {
        return this.gc;
    }

    private class Action_Accept
    implements ActionListener {
        EntityEditor e;

        public Action_Accept(EntityEditor e) {
            this.e = e;
        }

        @Override
        public void actionPerformed(ActionEvent q) {
            if (this.e.verifyLocation(new Vector(Double.parseDouble(EntityEditor.this.field_x.getText()), Double.parseDouble(EntityEditor.this.field_y.getText())))) {
                this.e.getEntity().setMass(Double.parseDouble(EntityEditor.this.field_mass.getText()));
                this.e.getEntity().setName(EntityEditor.this.field_name.getText());
                this.e.getEntity().setCharge(Double.parseDouble(EntityEditor.this.field_charge.getText()));
                this.e.getEntity().getPosition().setX(Double.parseDouble(EntityEditor.this.field_x.getText()));
                this.e.getEntity().getPosition().setY(Double.parseDouble(EntityEditor.this.field_y.getText()));
                this.e.getEntity().getVelocity().setX(Double.parseDouble(EntityEditor.this.field_x_velocity.getText()));
                this.e.getEntity().getVelocity().setY(Double.parseDouble(EntityEditor.this.field_y_velocity.getText()));
                this.e.getEntity().setDrag_coefficient(Double.parseDouble(EntityEditor.this.field_dragc.getText()));
                if ((String.valueOf(EntityEditor.this.field_color_r.getText()) + EntityEditor.this.field_color_g.getText() + EntityEditor.this.field_color_b.getText()).equalsIgnoreCase("fab")) {
                    this.e.getEntity().setFabulous(true);
                    this.e.getEntity().setColor(Color.RED);
                } else {
                    this.e.getEntity().setColor(new Color((int)Double.parseDouble(EntityEditor.this.field_color_r.getText()), (int)Double.parseDouble(EntityEditor.this.field_color_g.getText()), (int)Double.parseDouble(EntityEditor.this.field_color_b.getText()), (int)(255.0 * Double.parseDouble(EntityEditor.this.field_color_alpha.getText()))));
                }
                this.e.getEntity().setRadius(Double.parseDouble(EntityEditor.this.field_radius.getText()));
                this.e.getEntity().setTracelimit((int)Double.parseDouble(EntityEditor.this.field_tracelimit.getText()));
                this.e.getEntity().setTrace(EntityEditor.this.checkbox_trace.isSelected());
                this.e.getEntity().setCollidable(EntityEditor.this.checkbox_collidable.isSelected());
                this.e.getEntity().setPinned(EntityEditor.this.checkbox_pinned.isSelected());
                this.e.getEntity().setDrawVelocity(EntityEditor.this.checkbox_drawvelocity.isSelected());
                this.e.getEntity().setFinecircles(EntityEditor.this.gc.isFinecircles());
                if (this.e.isNew()) {
                    this.e.getGc().getEntities().add(this.e.getEntity());
                    this.e.getEntity().setuplog(EntityEditor.this.gc);
                }
                this.e.getEntity().updateShape();
                this.e.getGc().getRenderer().renderCycle();
                this.e.dispose();
            }
        }
    }

    private class Action_Cancel
    implements ActionListener {
        EntityEditor e;

        public Action_Cancel(EntityEditor e) {
            this.e = e;
        }

        @Override
        public void actionPerformed(ActionEvent q) {
            this.e.dispose();
        }
    }

    private class Action_Colorpicker
    implements ActionListener {
        EntityEditor e;

        public Action_Colorpicker(EntityEditor e) {
            this.e = e;
        }

        @Override
        public void actionPerformed(ActionEvent q) {
            EntityEditor.this.dialog_color = JColorChooser.showDialog(this.e, "Choose an Entity Color", this.e.getDialog_color());
            this.e.getField_color_r().setText(Double.toString(EntityEditor.this.dialog_color.getRed()));
            this.e.getField_color_g().setText(Double.toString(EntityEditor.this.dialog_color.getGreen()));
            this.e.getField_color_b().setText(Double.toString(EntityEditor.this.dialog_color.getBlue()));
        }
    }
}

