/*
 * Decompiled with CFR 0.152.
 */
package org.abs.bifrost.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.abs.bifrost.GroundControl;

public class EnvironmentEditor
extends JFrame {
    private static final long serialVersionUID = 1L;
    private GroundControl gc;
    private JTextField field_gravityX;
    private JTextField field_gravityY;
    private JTextField field_eX;
    private JTextField field_eY;
    private JTextField field_ppm;
    private JTextField field_fluiddensity;
    private JTextField field_timestep;
    private JCheckBox ambientgravity;
    private JCheckBox mutualgravity;
    private JCheckBox mutualelectric;
    private JCheckBox bounce_top;
    private JCheckBox bounce_right;
    private JCheckBox bounce_bottom;
    private JCheckBox bounce_left;
    private JCheckBox fluidresistance;
    private JButton button_accept;
    private JButton button_cancel;

    public EnvironmentEditor(GroundControl gc) {
        super("Environment Editor");
        this.gc = gc;
        this.setIconImage(gc.getIcon());
        int width = 250;
        int height = 340;
        this.setLocation((int)(gc.getEnvironmentWidth() - (double)width) / 2, (int)(gc.getEnvironmentHeight() - (double)height) / 2);
        JPanel pnl_main = (JPanel)this.getContentPane();
        pnl_main.setPreferredSize(new Dimension(width, height));
        pnl_main.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        this.bounce_top = new JCheckBox();
        this.bounce_top.setSelected(gc.isTopBounce());
        pnl_main.add((Component)this.bounce_top, c);
        ++c.gridx;
        pnl_main.add((Component)new JLabel("Bounce Top"), c);
        c.gridx = 0;
        ++c.gridy;
        this.bounce_right = new JCheckBox();
        this.bounce_right.setSelected(gc.isRightBounce());
        pnl_main.add((Component)this.bounce_right, c);
        ++c.gridx;
        pnl_main.add((Component)new JLabel("Bounce Right"), c);
        c.gridx = 0;
        ++c.gridy;
        this.bounce_bottom = new JCheckBox();
        this.bounce_bottom.setSelected(gc.isBottomBounce());
        pnl_main.add((Component)this.bounce_bottom, c);
        ++c.gridx;
        pnl_main.add((Component)new JLabel("Bounce Bottom"), c);
        c.gridx = 0;
        ++c.gridy;
        this.bounce_left = new JCheckBox();
        this.bounce_left.setSelected(gc.isRightBounce());
        pnl_main.add((Component)this.bounce_left, c);
        ++c.gridx;
        pnl_main.add((Component)new JLabel("Bounce Left"), c);
        c.gridx = 0;
        ++c.gridy;
        this.ambientgravity = new JCheckBox();
        this.ambientgravity.setSelected(gc.isAmbientgravity());
        pnl_main.add((Component)this.ambientgravity, c);
        ++c.gridx;
        pnl_main.add((Component)new JLabel("Gravitational Field"), c);
        c.gridx = 0;
        ++c.gridy;
        this.fluidresistance = new JCheckBox();
        this.fluidresistance.setSelected(gc.isFluidResistance());
        pnl_main.add((Component)this.fluidresistance, c);
        ++c.gridx;
        pnl_main.add((Component)new JLabel("Fluidic Resistance"), c);
        c.gridx = 0;
        ++c.gridy;
        this.mutualgravity = new JCheckBox();
        this.mutualgravity.setSelected(gc.isGravity());
        pnl_main.add((Component)this.mutualgravity, c);
        ++c.gridx;
        pnl_main.add((Component)new JLabel("Mutual Gravitation"), c);
        c.gridx = 0;
        ++c.gridy;
        this.mutualelectric = new JCheckBox();
        this.mutualelectric.setSelected(gc.isMutualelectric());
        pnl_main.add((Component)this.mutualelectric, c);
        ++c.gridx;
        pnl_main.add((Component)new JLabel("Mutual Electric"), c);
        c.gridx = 0;
        ++c.gridy;
        pnl_main.add((Component)new JLabel("Time Step: "), c);
        ++c.gridx;
        this.field_timestep = new JTextField();
        this.field_timestep.setText(Double.toString(gc.getTimeStep()));
        pnl_main.add((Component)this.field_timestep, c);
        c.gridx = 0;
        ++c.gridy;
        pnl_main.add((Component)new JLabel("Fluid Density: "), c);
        ++c.gridx;
        this.field_fluiddensity = new JTextField();
        this.field_fluiddensity.setText(Double.toString(gc.getEnv().getFluidDensity()));
        pnl_main.add((Component)this.field_fluiddensity, c);
        ++c.gridx;
        pnl_main.add((Component)new JLabel("kg/m^3"), c);
        c.gridx = 0;
        ++c.gridy;
        pnl_main.add((Component)new JLabel("PPM: "), c);
        ++c.gridx;
        this.field_ppm = new JTextField();
        this.field_ppm.setText(Double.toString(gc.getEnv().getppm()));
        pnl_main.add((Component)this.field_ppm, c);
        ++c.gridx;
        pnl_main.add((Component)new JLabel("pixel/meter"), c);
        c.gridx = 0;
        ++c.gridy;
        pnl_main.add((Component)new JLabel("Gravity X: "), c);
        ++c.gridx;
        this.field_gravityX = new JTextField();
        this.field_gravityX.setText(Double.toString(gc.getEnv().getGravity().getX()));
        pnl_main.add((Component)this.field_gravityX, c);
        ++c.gridx;
        pnl_main.add((Component)new JLabel("m/s^2"), c);
        c.gridx = 0;
        ++c.gridy;
        pnl_main.add((Component)new JLabel("Gravity Y: "), c);
        ++c.gridx;
        this.field_gravityY = new JTextField();
        this.field_gravityY.setText(Double.toString(gc.getEnv().getGravity().getY()));
        pnl_main.add((Component)this.field_gravityY, c);
        ++c.gridx;
        pnl_main.add((Component)new JLabel("m/s^2"), c);
        c.gridx = 0;
        ++c.gridy;
        pnl_main.add((Component)new JLabel("E Field X: "), c);
        ++c.gridx;
        this.field_eX = new JTextField();
        this.field_eX.setText(Double.toString(gc.getEnv().getEfield().getX()));
        pnl_main.add((Component)this.field_eX, c);
        ++c.gridx;
        pnl_main.add((Component)new JLabel("V/m"), c);
        c.gridx = 0;
        ++c.gridy;
        pnl_main.add((Component)new JLabel("E Field Y: "), c);
        ++c.gridx;
        this.field_eY = new JTextField();
        this.field_eY.setText(Double.toString(gc.getEnv().getEfield().getY()));
        pnl_main.add((Component)this.field_eY, c);
        ++c.gridx;
        pnl_main.add((Component)new JLabel("V/m"), c);
        c.gridx = 0;
        ++c.gridy;
        this.button_accept = new JButton("Accept");
        this.button_cancel = new JButton("Cancel");
        this.button_accept.addActionListener(new Action_Accept(this));
        this.button_cancel.addActionListener(new Action_Cancel(this));
        this.button_accept.setMnemonic(65);
        this.button_cancel.setMnemonic(67);
        pnl_main.add((Component)this.button_accept, c);
        ++c.gridx;
        pnl_main.add((Component)this.button_cancel, c);
        this.pack();
        this.setVisible(true);
    }

    private class Action_Accept
    implements ActionListener {
        EnvironmentEditor e;

        public Action_Accept(EnvironmentEditor e) {
            this.e = e;
        }

        @Override
        public void actionPerformed(ActionEvent q) {
            EnvironmentEditor.this.gc.setBorderBounce(EnvironmentEditor.this.bounce_top.isSelected(), EnvironmentEditor.this.bounce_right.isSelected(), EnvironmentEditor.this.bounce_bottom.isSelected(), EnvironmentEditor.this.bounce_left.isSelected());
            EnvironmentEditor.this.gc.setFluidResistance(EnvironmentEditor.this.fluidresistance.isSelected());
            EnvironmentEditor.this.gc.setMutualelectric(EnvironmentEditor.this.mutualelectric.isSelected());
            EnvironmentEditor.this.gc.setGravity(EnvironmentEditor.this.mutualgravity.isSelected());
            EnvironmentEditor.this.gc.setAmbientgravity(EnvironmentEditor.this.ambientgravity.isSelected());
            EnvironmentEditor.this.gc.getEnv().getGravity().setX(Double.parseDouble(EnvironmentEditor.this.field_gravityX.getText()));
            EnvironmentEditor.this.gc.getEnv().getGravity().setY(Double.parseDouble(EnvironmentEditor.this.field_gravityY.getText()));
            EnvironmentEditor.this.gc.getEnv().getEfield().setX(Double.parseDouble(EnvironmentEditor.this.field_eX.getText()));
            EnvironmentEditor.this.gc.getEnv().getEfield().setY(Double.parseDouble(EnvironmentEditor.this.field_eY.getText()));
            EnvironmentEditor.this.gc.getEnv().setppm(Double.parseDouble(EnvironmentEditor.this.field_ppm.getText()));
            EnvironmentEditor.this.gc.getEnv().setFluidDensity(Double.parseDouble(EnvironmentEditor.this.field_fluiddensity.getText()));
            EnvironmentEditor.this.gc.setTimeStep(Double.parseDouble(EnvironmentEditor.this.field_timestep.getText()));
            this.e.dispose();
        }
    }

    private class Action_Cancel
    implements ActionListener {
        EnvironmentEditor e;

        public Action_Cancel(EnvironmentEditor e) {
            this.e = e;
        }

        @Override
        public void actionPerformed(ActionEvent q) {
            this.e.dispose();
        }
    }
}

