/*
 * Decompiled with CFR 0.152.
 */
package org.abs.bifrost.gui.chat;

import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import org.abs.bifrost.GroundControl;
import org.abs.bifrost.gui.chat.User;
import org.abs.bifrost.tcpip.BifrostPayload;

public class ChatTextfield
extends TextField {
    private static final long serialVersionUID = 1L;
    private GroundControl gc;

    public ChatTextfield(GroundControl gc, User user) {
        this.gc = gc;
        this.addActionListener(new TextinputListener());
    }

    public GroundControl getGc() {
        return this.gc;
    }

    public void setGc(GroundControl gc) {
        this.gc = gc;
    }

    public class TextinputListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent arg0) {
            ChatTextfield ct = (ChatTextfield)arg0.getSource();
            if (ct.getText().charAt(0) != '/') {
                BifrostPayload bpyld;
                if (!ChatTextfield.this.gc.isClient() && !ChatTextfield.this.gc.isServer()) {
                    ct.getGc().getChatdisplay().addLine(ct.getText(), ChatTextfield.this.gc.getUser());
                    ct.setText("");
                } else if (ChatTextfield.this.gc.isClient()) {
                    bpyld = new BifrostPayload();
                    bpyld.setPyld(5);
                    bpyld.pack(ct.getText(), ChatTextfield.this.gc.getUser());
                    ChatTextfield.this.gc.getCmode().send(bpyld);
                    ct.setText("");
                } else if (ChatTextfield.this.gc.isServer()) {
                    ct.getGc().getChatdisplay().addLine(ct.getText(), ChatTextfield.this.gc.getUser());
                    bpyld = new BifrostPayload();
                    bpyld.setPyld(5);
                    bpyld.pack(ct.getText(), ChatTextfield.this.gc.getUser());
                    ChatTextfield.this.gc.getSmode().getServer().send(bpyld);
                    ct.setText("");
                }
            }
            if (ct.getText().charAt(0) == '/') {
                String[] command = ct.getText().substring(1).split(" ");
                if (command[0].equalsIgnoreCase("disconnect") && (ChatTextfield.this.gc.isClient() || ChatTextfield.this.gc.isServer())) {
                    ChatTextfield.this.gc.getChatdisplay().addConsoleLine("Recieved disconnect command via chat.");
                    ChatTextfield.this.gc.getMm().disconnect();
                }
                if (!ChatTextfield.this.gc.isClient() && ChatTextfield.this.gc.getRenderer().isPaused()) {
                    if (command[0].equalsIgnoreCase("connect")) {
                        String[] connectInfo = command[1].split("@");
                        ChatTextfield.this.gc.getMm().connect(connectInfo[0], connectInfo[1]);
                    } else if (command[0].equalsIgnoreCase("host")) {
                        String[] connectInfo = command[1].split("@");
                        ChatTextfield.this.gc.getUser().setUsername(connectInfo[0]);
                        ArrayList<User> temp = new ArrayList<User>();
                        ChatTextfield.this.gc.getUser().setUid(0);
                        ChatTextfield.this.gc.getUser().setRank(5);
                        temp.add(ChatTextfield.this.gc.getUser());
                        ChatTextfield.this.gc.getChatdisplay().getCu().setUsers(temp);
                        ChatTextfield.this.gc.getMm().host(Integer.parseInt(connectInfo[1]));
                    }
                }
                ct.setText("");
            }
        }
    }
}

