/*
 * Decompiled with CFR 0.152.
 */
package org.abs.bifrost.gui.chat;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.abs.bifrost.GroundControl;
import org.abs.bifrost.gui.chat.User;
import org.abs.bifrost.tcpip.BifrostPayload;

public class ChatUsers
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private volatile ArrayList<User> users;
    private DefaultListModel model;
    private GroundControl gc;
    private ChatUsers cu = this;

    public ChatUsers(GroundControl gc) {
        this.gc = gc;
        this.users = new ArrayList();
        this.model = new DefaultListModel();
    }

    public void setUsers(ArrayList<User> user2) {
        int i = this.users.size();
        while (i > 0) {
            this.users.remove(i - 1);
            --i;
        }
        for (User u : user2) {
            this.addUser(u);
        }
    }

    public ArrayList<User> getUsers() {
        return this.users;
    }

    public void addUser(User user) {
        this.users.add(user);
        this.orderList();
        this.showList();
    }

    public void delUser(int uid) {
        int i = 0;
        while (i < this.users.size()) {
            if (this.users.get(i).getUid() == uid) {
                this.users.remove(i);
                break;
            }
            ++i;
        }
        this.orderList();
        this.showList();
    }

    public void showList() {
        this.model.removeAllElements();
        for (User u : this.users) {
            this.model.addElement(u.toString());
        }
        this.getViewport().removeAll();
        JList list = new JList(this.model);
        list.addMouseListener(new ListMouseListener(list));
        list.setSelectionMode(0);
        list.setLayoutOrientation(0);
        list.setVisibleRowCount(-1);
        this.getViewport().add(list);
    }

    public void orderList() {
        boolean doMore = true;
        while (doMore) {
            doMore = false;
            int i = 0;
            while (i < this.users.size() - 1) {
                if (this.users.get(i).getRank() < this.users.get(i + 1).getRank()) {
                    User temp = this.users.get(i);
                    this.users.remove(i);
                    this.users.add(i + 1, temp);
                    doMore = true;
                }
                ++i;
            }
        }
    }

    private class KickListener
    implements ActionListener {
        int uindex;

        public KickListener(int uindex) {
            this.uindex = uindex;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (ChatUsers.this.gc.getUser().getRank() > ((User)ChatUsers.this.users.get(this.uindex)).getRank() || ChatUsers.this.gc.getUser().getRank() == 5) {
                if (ChatUsers.this.gc.isClient() || ChatUsers.this.gc.isServer()) {
                    BifrostPayload bp = new BifrostPayload();
                    bp.setPyld(2);
                    bp.pack((User)ChatUsers.this.users.get(this.uindex));
                    ChatUsers.this.gc.getSmode().getServer().send(bp);
                    ChatUsers.this.cu.orderList();
                    ChatUsers.this.cu.showList();
                }
            } else {
                ChatUsers.this.gc.getChatdisplay().addConsoleLine("You don't have proper permissions to do that!");
            }
        }
    }

    private class ListMouseListener
    implements MouseListener {
        JList listView;

        public ListMouseListener(JList l) {
            this.listView = l;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int idx = -1;
            if (e.getButton() == 3 && (idx = this.listView.locationToIndex(e.getPoint())) != -1) {
                this.listView.setSelectedIndex(idx);
                UserPopup up = new UserPopup(idx);
                up.show((JList)e.getSource(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }
    }

    private class PromoteListener
    implements ActionListener {
        private int toRank;
        private int index;

        public PromoteListener(int toRank, int userindex) {
            this.toRank = toRank;
            this.index = userindex;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (ChatUsers.this.gc.getUser().getRank() > this.toRank || ChatUsers.this.gc.getUser().getRank() == 5) {
                ((User)ChatUsers.this.users.get(this.index)).setRank(this.toRank);
                ChatUsers.this.gc.getChatdisplay().addConsoleLine("Successfully promoted " + ((User)ChatUsers.this.users.get(this.index)).getUsername() + " to rank " + this.toRank);
                ChatUsers.this.cu.orderList();
                ChatUsers.this.cu.showList();
                if (ChatUsers.this.gc.isServer()) {
                    BifrostPayload newUserlist = new BifrostPayload();
                    newUserlist.setPyld(0);
                    newUserlist.pack(ChatUsers.this.users);
                    ChatUsers.this.gc.getSmode().getServer().send(newUserlist);
                } else if (ChatUsers.this.gc.isClient()) {
                    BifrostPayload newUserlist = new BifrostPayload();
                    newUserlist.setPyld(0);
                    newUserlist.pack(ChatUsers.this.users);
                    ChatUsers.this.gc.getCmode().send(newUserlist);
                }
            } else {
                ChatUsers.this.gc.getChatdisplay().addConsoleLine("You don't have proper permissions to do that!");
            }
        }
    }

    private class UserPopup
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;

        public UserPopup(int userindex) {
            JMenu menu_Promote = new JMenu("Promote");
            JMenuItem mi_toSilence = new JMenuItem("Silenced");
            mi_toSilence.addActionListener(new PromoteListener(0, userindex));
            JMenuItem mi_toRegular = new JMenuItem("Regular");
            mi_toRegular.addActionListener(new PromoteListener(1, userindex));
            JMenuItem mi_toVoice = new JMenuItem("Voice");
            mi_toVoice.addActionListener(new PromoteListener(2, userindex));
            JMenuItem mi_toHalfmoderator = new JMenuItem("Halfmoderator");
            mi_toHalfmoderator.addActionListener(new PromoteListener(3, userindex));
            JMenuItem mi_toModerator = new JMenuItem("Moderator");
            mi_toModerator.addActionListener(new PromoteListener(4, userindex));
            JMenuItem mi_toOperator = new JMenuItem("Operator");
            mi_toOperator.addActionListener(new PromoteListener(5, userindex));
            menu_Promote.add(mi_toSilence);
            menu_Promote.add(mi_toRegular);
            menu_Promote.add(mi_toVoice);
            menu_Promote.add(mi_toHalfmoderator);
            menu_Promote.add(mi_toModerator);
            menu_Promote.add(mi_toOperator);
            JMenuItem mi_Kick = new JMenuItem("Kick");
            mi_Kick.addActionListener(new KickListener(userindex));
            this.add(mi_Kick);
        }
    }
}

