/*
 * Decompiled with CFR 0.152.
 */
package org.abs.bifrost.physics;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.abs.bifrost.GroundControl;
import org.abs.bifrost.entities.Entity;
import org.abs.bifrost.physics.Vector;

public class Simulator
implements Runnable {
    GroundControl groundcontrol;
    private List<Entity> ents;
    private List<Vector> positionSteps;
    private List<Vector> netAccelerations;
    private SimulationThread[] simulGroup;
    private Thread[] threadGroup;
    private int processors;
    private int entity_count;

    public Simulator(GroundControl groundcontrol) {
        this.groundcontrol = groundcontrol;
        this.positionSteps = new ArrayList<Vector>();
        this.netAccelerations = new ArrayList<Vector>();
        this.processors = groundcontrol.getProcessors();
        this.entity_count = 0;
        this.threadGroup = new Thread[this.processors];
        this.simulGroup = new SimulationThread[this.processors];
        int i = 0;
        while (i < this.processors) {
            this.simulGroup[i] = new SimulationThread();
            ++i;
        }
    }

    @Override
    public void run() {
        while (true) {
            int rSiphon;
            int remainder;
            if (this.groundcontrol.getRenderer().isPaused() || !this.groundcontrol.isSimulate()) {
                continue;
            }
            this.groundcontrol.getRenderer().setIterations(this.groundcontrol.getRenderer().getIterations() + 1);
            this.ents = this.groundcontrol.getEntities();
            this.positionSteps.clear();
            this.netAccelerations.clear();
            int i = 0;
            while (i < this.ents.size()) {
                this.positionSteps.add(new Vector());
                this.netAccelerations.add(new Vector());
                ++i;
            }
            if (this.entity_count != this.ents.size()) {
                this.entity_count = this.ents.size();
                int perProcessor = this.entity_count / this.processors;
                remainder = this.entity_count % this.processors;
                rSiphon = remainder > 0 ? 1 : 0;
                int entnum = 0;
                int i2 = 0;
                while (i2 < this.simulGroup.length) {
                    this.simulGroup[i2].setData(entnum, entnum + perProcessor + rSiphon);
                    entnum += perProcessor + rSiphon;
                    rSiphon = (remainder -= rSiphon) > 0 ? 1 : 0;
                    ++i2;
                }
            }
            i = 0;
            while (i < this.simulGroup.length) {
                this.threadGroup[i] = new Thread(this.simulGroup[i]);
                this.threadGroup[i].start();
                ++i;
            }
            Thread[] threadArray = this.threadGroup;
            rSiphon = this.threadGroup.length;
            remainder = 0;
            while (remainder < rSiphon) {
                Thread t = threadArray[remainder];
                try {
                    t.join();
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                ++remainder;
            }
            i = 0;
            while (i < this.ents.size()) {
                this.netAccelerations.get(i).timesScalar(this.groundcontrol.getTimeStep());
                this.positionSteps.get(i).timesScalar(this.groundcontrol.getEnv().getppm());
                if (!this.ents.get(i).isPinned()) {
                    this.ents.get(i).getPosition().add(this.positionSteps.get(i));
                    this.ents.get(i).getVelocity().add(this.netAccelerations.get(i));
                }
                ++i;
            }
            Stack<Entity> entStack = new Stack<Entity>();
            for (Entity e : this.ents) {
                if (!e.isCollidable()) continue;
                entStack.push(e);
            }
            while (entStack.size() > 0) {
                Entity current = (Entity)entStack.pop();
                for (Entity e : entStack) {
                    current.collide(e);
                }
            }
            this.groundcontrol.setSimulate(false);
        }
    }

    private class SimulationThread
    implements Runnable {
        private int start;
        private int end;

        public void setData(int start, int end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public void run() {
            int i = this.start;
            while (i < this.end) {
                if (!((Entity)Simulator.this.ents.get(i)).isPinned()) {
                    double accel;
                    Vector direction;
                    int j;
                    Vector netAcceleration = new Vector(0.0, 0.0);
                    if (Simulator.this.groundcontrol.isAmbientgravity()) {
                        netAcceleration.add(Simulator.this.groundcontrol.getEnv().getGravity());
                    }
                    Vector electricalField = new Vector(Simulator.this.groundcontrol.getEnv().getEfield());
                    electricalField.timesScalar(((Entity)Simulator.this.ents.get(i)).getCharge());
                    electricalField.timesScalar(1.0 / ((Entity)Simulator.this.ents.get(i)).getMass());
                    netAcceleration.add(electricalField);
                    if (Simulator.this.groundcontrol.isFluidResistance()) {
                        double scalar = -0.5 * Simulator.this.groundcontrol.getEnv().getFluidDensity() * ((Entity)Simulator.this.ents.get(i)).getDrag_coefficient() * Math.PI * Math.pow(((Entity)Simulator.this.ents.get(i)).getWidth() / (2.0 * Simulator.this.groundcontrol.getEnv().getppm()), 2.0) * ((Entity)Simulator.this.ents.get(i)).getVelocity().dot(((Entity)Simulator.this.ents.get(i)).getVelocity());
                        Vector drag = new Vector(((Entity)Simulator.this.ents.get(i)).getVelocity());
                        if (drag.getR() > 0.0) {
                            drag.timesScalar(1.0 / drag.getR());
                        }
                        drag.timesScalar(scalar / ((Entity)Simulator.this.ents.get(i)).getMass());
                        netAcceleration.add(drag);
                    }
                    if (Simulator.this.groundcontrol.isGravity()) {
                        Vector externalGravitation = new Vector(0.0, 0.0);
                        double G = 6.67428E-11;
                        j = 0;
                        while (j < Simulator.this.ents.size()) {
                            if (j != i && (direction = new Vector(((Entity)Simulator.this.ents.get(j)).getPosition().getX() - ((Entity)Simulator.this.ents.get(i)).getPosition().getX(), ((Entity)Simulator.this.ents.get(j)).getPosition().getY() - ((Entity)Simulator.this.ents.get(i)).getPosition().getY())).getR() != 0.0) {
                                accel = G * ((Entity)Simulator.this.ents.get(j)).getMass() * 1.0 / Math.pow(direction.getR() / Simulator.this.groundcontrol.getEnv().getppm(), 2.0);
                                direction.timesScalar(1.0 / direction.getR());
                                Vector grav = new Vector(direction);
                                grav.timesScalar(accel);
                                externalGravitation.add(grav);
                            }
                            ++j;
                        }
                        netAcceleration.add(externalGravitation);
                    }
                    if (Simulator.this.groundcontrol.isMutualelectric()) {
                        Vector externalElectric = new Vector(0.0, 0.0);
                        double k = 8.987551787368176E9;
                        j = 0;
                        while (j < Simulator.this.ents.size()) {
                            if (j != i) {
                                direction = new Vector(((Entity)Simulator.this.ents.get(j)).getPosition().getX() - ((Entity)Simulator.this.ents.get(i)).getPosition().getX(), ((Entity)Simulator.this.ents.get(j)).getPosition().getY() - ((Entity)Simulator.this.ents.get(i)).getPosition().getY());
                                accel = -k / ((Entity)Simulator.this.ents.get(i)).getMass() * ((Entity)Simulator.this.ents.get(j)).getCharge() * ((Entity)Simulator.this.ents.get(i)).getCharge() * 1.0 / Math.pow(direction.getR() / Simulator.this.groundcontrol.getEnv().getppm(), 2.0);
                                if (direction.getR() != 0.0) {
                                    direction.timesScalar(1.0 / direction.getR());
                                    Vector coloumb = new Vector(direction);
                                    coloumb.timesScalar(accel);
                                    externalElectric.add(coloumb);
                                }
                            }
                            ++j;
                        }
                        netAcceleration.add(externalElectric);
                    }
                    if (Simulator.this.groundcontrol.isTopBounce() && ((Entity)Simulator.this.ents.get(i)).getPosition().getY() + ((Entity)Simulator.this.ents.get(i)).getHeight() / 2.0 >= Simulator.this.groundcontrol.getEnvironmentHeight()) {
                        ((Entity)Simulator.this.ents.get(i)).getVelocity().setY(((Entity)Simulator.this.ents.get(i)).getVelocity().getY() * -1.0);
                    }
                    if (Simulator.this.groundcontrol.isBottomBounce() && ((Entity)Simulator.this.ents.get(i)).getPosition().getY() - ((Entity)Simulator.this.ents.get(i)).getHeight() / 2.0 <= 0.0) {
                        ((Entity)Simulator.this.ents.get(i)).getVelocity().setY(((Entity)Simulator.this.ents.get(i)).getVelocity().getY() * -1.0);
                    }
                    if (Simulator.this.groundcontrol.isRightBounce() && ((Entity)Simulator.this.ents.get(i)).getPosition().getX() + ((Entity)Simulator.this.ents.get(i)).getWidth() / 2.0 >= Simulator.this.groundcontrol.getEnvironmentWidth()) {
                        ((Entity)Simulator.this.ents.get(i)).getVelocity().setX(((Entity)Simulator.this.ents.get(i)).getVelocity().getX() * -1.0);
                    }
                    if (Simulator.this.groundcontrol.isLeftBounce() && ((Entity)Simulator.this.ents.get(i)).getPosition().getX() - ((Entity)Simulator.this.ents.get(i)).getWidth() / 2.0 <= 0.0) {
                        ((Entity)Simulator.this.ents.get(i)).getVelocity().setX(((Entity)Simulator.this.ents.get(i)).getVelocity().getX() * -1.0);
                    }
                    ((Vector)Simulator.this.netAccelerations.get(i)).add(netAcceleration);
                    Vector posiStep = new Vector(0.0, 0.0);
                    posiStep.setX(((Entity)Simulator.this.ents.get(i)).getVelocity().getX() * Simulator.this.groundcontrol.getTimeStep() + 0.5 * netAcceleration.getX() * Math.pow(Simulator.this.groundcontrol.getTimeStep(), 2.0));
                    posiStep.setY(((Entity)Simulator.this.ents.get(i)).getVelocity().getY() * Simulator.this.groundcontrol.getTimeStep() + 0.5 * netAcceleration.getY() * Math.pow(Simulator.this.groundcontrol.getTimeStep(), 2.0));
                    ((Vector)Simulator.this.positionSteps.get(i)).add(posiStep);
                }
                ++i;
            }
        }
    }
}

