/*
 * Decompiled with CFR 0.152.
 */
package org.abs.bifrost.physics;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.abs.bifrost.GroundControl;
import org.abs.bifrost.entities.Entity;
import org.abs.bifrost.physics.Vector;

public class Simulator_OLD
implements Runnable {
    GroundControl groundcontrol;
    int counter;

    public Simulator_OLD(GroundControl groundcontrol) {
        this.groundcontrol = groundcontrol;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        while (true) {
            void var4_11;
            void var4_9;
            void var4_6;
            if (this.groundcontrol.getRenderer().isPaused() || !this.groundcontrol.isSimulate()) {
                continue;
            }
            List<Entity> ents = this.groundcontrol.getEntities();
            ArrayList<Vector> positionSteps = new ArrayList<Vector>();
            ArrayList<Object> netAccelerations = new ArrayList<Object>();
            boolean bl = false;
            while (var4_6 < ents.size()) {
                double accel;
                Vector direction;
                int j;
                Vector netAcceleration = new Vector(0.0, 0.0);
                if (this.groundcontrol.isAmbientgravity()) {
                    netAcceleration.add(this.groundcontrol.getEnv().getGravity());
                }
                Vector electricalField = new Vector(this.groundcontrol.getEnv().getEfield());
                electricalField.timesScalar(ents.get((int)var4_6).getCharge());
                electricalField.timesScalar(1.0 / ents.get((int)var4_6).getMass());
                netAcceleration.add(electricalField);
                if (this.groundcontrol.isFluidResistance()) {
                    double scalar = -0.5 * this.groundcontrol.getEnv().getFluidDensity() * ents.get((int)var4_6).getDrag_coefficient() * Math.PI * Math.pow(ents.get((int)var4_6).getWidth() / (2.0 * this.groundcontrol.getEnv().getppm()), 2.0) * ents.get((int)var4_6).getVelocity().dot(ents.get((int)var4_6).getVelocity());
                    Vector drag = new Vector(ents.get((int)var4_6).getVelocity());
                    if (drag.getR() > 0.0) {
                        drag.timesScalar(1.0 / drag.getR());
                    }
                    drag.timesScalar(scalar / ents.get((int)var4_6).getMass());
                    netAcceleration.add(drag);
                }
                if (this.groundcontrol.isGravity()) {
                    Vector externalGravitation = new Vector(0.0, 0.0);
                    double G = 6.67428E-11;
                    j = 0;
                    while (j < ents.size()) {
                        if (j != var4_6 && (direction = new Vector(ents.get(j).getPosition().getX() - ents.get((int)var4_6).getPosition().getX(), ents.get(j).getPosition().getY() - ents.get((int)var4_6).getPosition().getY())).getR() != 0.0) {
                            accel = G * ents.get(j).getMass() * 1.0 / Math.pow(direction.getR() / this.groundcontrol.getEnv().getppm(), 2.0);
                            direction.timesScalar(1.0 / direction.getR());
                            Vector grav = new Vector(direction);
                            grav.timesScalar(accel);
                            externalGravitation.add(grav);
                        }
                        ++j;
                    }
                    netAcceleration.add(externalGravitation);
                }
                if (this.groundcontrol.isMutualelectric()) {
                    Vector externalElectric = new Vector(0.0, 0.0);
                    double k = 8.987551787368176E9;
                    j = 0;
                    while (j < ents.size()) {
                        if (j != var4_6) {
                            direction = new Vector(ents.get(j).getPosition().getX() - ents.get((int)var4_6).getPosition().getX(), ents.get(j).getPosition().getY() - ents.get((int)var4_6).getPosition().getY());
                            accel = -k / ents.get((int)var4_6).getMass() * ents.get(j).getCharge() * ents.get((int)var4_6).getCharge() * 1.0 / Math.pow(direction.getR() / this.groundcontrol.getEnv().getppm(), 2.0);
                            if (direction.getR() != 0.0) {
                                direction.timesScalar(1.0 / direction.getR());
                                Vector coloumb = new Vector(direction);
                                coloumb.timesScalar(accel);
                                externalElectric.add(coloumb);
                            }
                        }
                        ++j;
                    }
                    netAcceleration.add(externalElectric);
                }
                if (this.groundcontrol.isTopBounce() && ents.get((int)var4_6).getPosition().getY() + ents.get((int)var4_6).getHeight() / 2.0 >= this.groundcontrol.getEnvironmentHeight()) {
                    ents.get((int)var4_6).getVelocity().setY(ents.get((int)var4_6).getVelocity().getY() * -1.0);
                }
                if (this.groundcontrol.isBottomBounce() && ents.get((int)var4_6).getPosition().getY() - ents.get((int)var4_6).getHeight() / 2.0 <= 0.0) {
                    ents.get((int)var4_6).getVelocity().setY(ents.get((int)var4_6).getVelocity().getY() * -1.0);
                }
                if (this.groundcontrol.isRightBounce() && ents.get((int)var4_6).getPosition().getX() + ents.get((int)var4_6).getWidth() / 2.0 >= this.groundcontrol.getEnvironmentWidth()) {
                    ents.get((int)var4_6).getVelocity().setX(ents.get((int)var4_6).getVelocity().getX() * -1.0);
                }
                if (this.groundcontrol.isLeftBounce() && ents.get((int)var4_6).getPosition().getX() - ents.get((int)var4_6).getWidth() / 2.0 <= 0.0) {
                    ents.get((int)var4_6).getVelocity().setX(ents.get((int)var4_6).getVelocity().getX() * -1.0);
                }
                netAccelerations.add((int)var4_6, netAcceleration);
                Vector posiStep = new Vector(0.0, 0.0);
                posiStep.setX(ents.get((int)var4_6).getVelocity().getX() * this.groundcontrol.getTimeStep() + 0.5 * netAcceleration.getX() * Math.pow(this.groundcontrol.getTimeStep(), 2.0));
                posiStep.setY(ents.get((int)var4_6).getVelocity().getY() * this.groundcontrol.getTimeStep() + 0.5 * netAcceleration.getY() * Math.pow(this.groundcontrol.getTimeStep(), 2.0));
                positionSteps.add((int)var4_6, posiStep);
                ++var4_6;
            }
            for (Vector vector : netAccelerations) {
                vector.timesScalar(this.groundcontrol.getTimeStep());
            }
            boolean bl2 = false;
            while (var4_9 < ents.size()) {
                ((Vector)positionSteps.get((int)var4_9)).timesScalar(this.groundcontrol.getEnv().getppm());
                ++var4_9;
            }
            boolean bl3 = false;
            while (var4_11 < ents.size()) {
                if (!ents.get((int)var4_11).isPinned()) {
                    ents.get((int)var4_11).getPosition().add((Vector)positionSteps.get((int)var4_11));
                    ents.get((int)var4_11).getVelocity().add((Vector)netAccelerations.get((int)var4_11));
                }
                ++var4_11;
            }
            Stack<Entity> stack = new Stack<Entity>();
            for (Entity e : ents) {
                if (!e.isCollidable()) continue;
                stack.push(e);
            }
            while (stack.size() > 0) {
                Entity current = (Entity)stack.pop();
                for (Entity e : stack) {
                    current.collide(e);
                }
            }
            this.groundcontrol.setSimulate(false);
        }
    }
}

