/*
 * Decompiled with CFR 0.152.
 */
package org.abs.bifrost.physics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;

public class Vector {
    double x;
    double y;

    public Vector(Vector v) {
        this.x = v.getX();
        this.y = v.getY();
    }

    public Vector(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public void add(Vector v) {
        this.setX(this.getX() + v.getX());
        this.setY(this.getY() + v.getY());
    }

    public double dot(Vector v) {
        return this.getX() * v.getX() + this.getY() * v.getY();
    }

    public void timesScalar(double d) {
        this.setX(this.getX() * d);
        this.setY(this.getY() * d);
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getR() {
        return Math.sqrt(Math.pow(this.x, 2.0) + Math.pow(this.y, 2.0));
    }

    public void rotate(double aor) {
        double newangle = this.getAngle() + aor;
        double previousr = this.getR();
        this.setX(previousr * Math.cos(Math.toRadians(newangle)));
        this.setY(previousr * Math.sin(Math.toRadians(newangle)));
    }

    public double getAngle() {
        double angle = 0.0;
        if (this.getR() == 0.0) {
            return 0.0;
        }
        if (this.getR() == this.x) {
            return 0.0;
        }
        if (this.getR() == -this.x) {
            return 180.0;
        }
        if (this.getR() == this.y) {
            return 90.0;
        }
        if (this.getR() == -this.y) {
            return 270.0;
        }
        angle = Math.atan(Math.abs(this.y / this.x));
        angle = Math.toDegrees(angle);
        if (this.y >= 0.0 && this.x >= 0.0) {
            return angle;
        }
        if (this.y >= 0.0 && this.x < 0.0) {
            angle = 180.0 - angle;
            return angle;
        }
        if (this.y < 0.0 && this.x >= 0.0) {
            angle = 360.0 - angle;
            return angle;
        }
        if (this.y < 0.0 && this.x < 0.0) {
            return angle += 180.0;
        }
        return angle;
    }

    public void draw(Graphics2D g2d, int xCenter, int yCenter, float stroke, Color color) {
        g2d.setColor(color);
        int x = (int)this.x + xCenter;
        int y = (int)this.y + yCenter;
        double aDir = Math.atan2(xCenter - x, yCenter - y);
        g2d.drawLine(x, y, xCenter, yCenter);
        g2d.setStroke(new BasicStroke(1.0f));
        Polygon tmpPoly = new Polygon();
        int i1 = 12 + (int)(stroke * 2.0f);
        int i2 = 6 + (int)stroke;
        tmpPoly.addPoint(x, y);
        tmpPoly.addPoint(x + Vector.xCor(i1, aDir + 0.5), y + Vector.yCor(i1, aDir + 0.5));
        tmpPoly.addPoint(x + Vector.xCor(i2, aDir), y + Vector.yCor(i2, aDir));
        tmpPoly.addPoint(x + Vector.xCor(i1, aDir - 0.5), y + Vector.yCor(i1, aDir - 0.5));
        tmpPoly.addPoint(x, y);
        g2d.drawPolygon(tmpPoly);
        g2d.fillPolygon(tmpPoly);
    }

    private static int yCor(int len, double dir) {
        return (int)((double)len * Math.cos(dir));
    }

    private static int xCor(int len, double dir) {
        return (int)((double)len * Math.sin(dir));
    }

    public boolean equals(Vector other) {
        return other.getX() == this.getX() && other.getY() == this.getY();
    }

    public String toString() {
        String ret = "";
        ret = "<" + this.x + ", " + this.y + "> (" + this.getR() + ", " + this.getAngle() + ") ";
        return ret;
    }
}

