/*
 * Decompiled with CFR 0.152.
 */
package org.abs.bifrost.tcpip;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.abs.bifrost.GroundControl;
import org.abs.bifrost.fileio.BPFileHandler;
import org.abs.bifrost.gui.chat.User;
import org.abs.bifrost.tcpip.BifrostPayload;
import org.abs.bifrost.tcpip.InputHandler;
import org.abs.bifrost.tcpip.OutputHandler;
import org.abs.bifrost.tcpip.TransferPayload;

public class ClientMode
implements Runnable {
    private Socket socket;
    private TransferPayload inPayload;
    private TransferPayload outPayload;
    private GroundControl gc;
    private OutputHandler oh;
    private InputHandler ih;
    private Thread inputThread;
    private Thread outputThread;
    private boolean initialized = false;

    public boolean initialize(GroundControl gc, String ip, int port) {
        this.gc = gc;
        gc.setClient(true);
        try {
            this.socket = new Socket(ip, port);
        }
        catch (UnknownHostException e) {
            gc.getChatdisplay().addConsoleLine("Cannot connect to host.");
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            gc.getChatdisplay().addConsoleLine("Cannot connect to host.");
            e.printStackTrace();
            return false;
        }
        this.inPayload = new TransferPayload();
        this.outPayload = new TransferPayload();
        this.oh = null;
        try {
            this.oh = new OutputHandler(this.outPayload, new ObjectOutputStream(this.socket.getOutputStream()));
        }
        catch (IOException e) {
            gc.getChatdisplay().addConsoleLine("Could not create output stream.");
            e.printStackTrace();
            return false;
        }
        this.ih = null;
        try {
            this.ih = new InputHandler(this.inPayload, new ObjectInputStream(this.socket.getInputStream()));
        }
        catch (IOException e) {
            gc.getChatdisplay().addConsoleLine("Could not create input stream.");
            e.printStackTrace();
            return false;
        }
        this.inputThread = new Thread(this.ih);
        this.outputThread = new Thread(this.oh);
        this.inputThread.start();
        this.outputThread.start();
        this.initialized = true;
        return true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public void send(BifrostPayload bpyld) {
        this.outPayload.putPayload(bpyld);
    }

    @Override
    public void run() {
        BifrostPayload bpyld = null;
        while (this.initialized) {
            bpyld = this.inPayload.getPayload();
            this.parsePayload(bpyld);
        }
        System.out.println("Client not initialized");
    }

    public void parsePayload(BifrostPayload bpyld) {
        switch (bpyld.getPyld()) {
            case 5: {
                this.chatAdd(bpyld);
                break;
            }
            case 7: {
                this.chatConsole(bpyld);
                break;
            }
            case 0: {
                System.out.println("Got chat users");
                this.chatUsers(bpyld);
                break;
            }
            case -1: {
                this.init(bpyld);
                break;
            }
            case 2: {
                this.kick(bpyld);
                break;
            }
            case 4: {
                this.pause(bpyld);
                break;
            }
            case 1: {
                this.phys(bpyld);
                break;
            }
            case 3: {
                this.play(bpyld);
                break;
            }
            case 6: {
                this.disc();
            }
        }
    }

    public void sendDisc() {
        BifrostPayload bp = new BifrostPayload();
        bp.setPyld(6);
        bp.pack(this.gc.getUser());
        this.send(bp);
    }

    public void disc() {
        System.out.println("Got disc!!");
        this.gc.getMm().clientDC();
        this.gc.getRenderer().stop();
        this.initialized = false;
        ArrayList<User> temp = new ArrayList<User>();
        this.gc.getUser().setRank(5);
        temp.add(this.gc.getUser());
        this.gc.getChatdisplay().getCu().setUsers(temp);
        try {
            this.socket.close();
            this.gc.getChatdisplay().addConsoleLine("Disconnected from server.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.gc.setClient(false);
    }

    private void play(BifrostPayload bpyld) {
        this.gc.getRenderer().play();
    }

    private void phys(BifrostPayload bpyld) {
        this.gc.getRenderer().stop();
        BPFileHandler fh = new BPFileHandler(this.gc);
        fh.readFromArrayList(bpyld.getPhys_file());
    }

    private void pause(BifrostPayload bpyld) {
        this.gc.getRenderer().stop();
    }

    public void chatConsole(BifrostPayload pyld) {
        this.gc.getChatdisplay().addConsoleLine(pyld.getChat_add());
    }

    public void chatAdd(BifrostPayload pyld) {
        this.gc.getChatdisplay().addLine(pyld.getChat_add(), pyld.getUser());
    }

    public void chatUsers(BifrostPayload pyld) {
        this.gc.getChatdisplay().getCu().setUsers(pyld.getUsers());
        System.out.println("Size of users : " + pyld.getUsers().size());
        for (User u : pyld.getUsers()) {
            if (u.getUid() != this.gc.getUser().getUid()) continue;
            this.gc.setUser(u);
        }
    }

    private void init(BifrostPayload pyld) {
        this.gc.getUser().setUid(pyld.getUid());
        this.gc.getUser().setRank(1);
        BifrostPayload bp = new BifrostPayload();
        bp.setPyld(0);
        bp.pack(this.gc.getUser());
        this.send(bp);
    }

    public void kick(BifrostPayload pyld) {
        if (this.gc.getUser().getUid() == pyld.getUser().getUid()) {
            this.gc.getChatdisplay().addConsoleLine("Kicked from server.");
            BifrostPayload bp = new BifrostPayload();
            bp.setPyld(6);
            bp.pack(this.gc.getUser());
            this.send(bp);
        }
    }
}

